/*
 * Decompiled with CFR 0.152.
 */
package com.stx.xhb.xbanner.transformers;

import android.support.v4.view.ViewCompat;
import android.view.View;
import com.stx.xhb.xbanner.transformers.BasePageTransformer;

public class RotatePageTransformer
extends BasePageTransformer {
    private float mMaxRotation = 15.0f;

    public RotatePageTransformer() {
    }

    public RotatePageTransformer(float maxRotation) {
        this.setMaxRotation(maxRotation);
    }

    @Override
    public void handleInvisiblePage(View view, float position) {
        ViewCompat.setPivotX((View)view, (float)((float)view.getMeasuredWidth() * 0.5f));
        ViewCompat.setPivotY((View)view, (float)view.getMeasuredHeight());
        ViewCompat.setRotation((View)view, (float)0.0f);
    }

    @Override
    public void handleLeftPage(View view, float position) {
        float rotation = this.mMaxRotation * position;
        ViewCompat.setPivotX((View)view, (float)((float)view.getMeasuredWidth() * 0.5f));
        ViewCompat.setPivotY((View)view, (float)view.getMeasuredHeight());
        ViewCompat.setRotation((View)view, (float)rotation);
    }

    @Override
    public void handleRightPage(View view, float position) {
        this.handleLeftPage(view, position);
    }

    public void setMaxRotation(float maxRotation) {
        if (maxRotation >= 0.0f && maxRotation <= 40.0f) {
            this.mMaxRotation = maxRotation;
        }
    }
}

