/*
 * Decompiled with CFR 0.152.
 */
package fr.xgouchet.elmyr.regex;

import fr.xgouchet.elmyr.Forger;
import fr.xgouchet.elmyr.regex.RawChar;
import fr.xgouchet.elmyr.regex.RegexCharRangeNode;
import fr.xgouchet.elmyr.regex.RegexNode;
import fr.xgouchet.elmyr.regex.RegexParentNode;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0014\u0010\u0013\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lfr/xgouchet/elmyr/regex/RegexChoiceNode;", "Lfr/xgouchet/elmyr/regex/RegexParentNode;", "parent", "(Lfr/xgouchet/elmyr/regex/RegexParentNode;)V", "ongoingRange", "", "add", "", "b", "Lfr/xgouchet/elmyr/regex/RegexNode;", "buildIteration", "forger", "Lfr/xgouchet/elmyr/Forger;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "buildRange", "from", "to", "describe", "handle", "c", "", "library"})
public final class RegexChoiceNode
extends RegexParentNode {
    private boolean ongoingRange;

    @Override
    public boolean handle(char c) {
        boolean bl;
        switch (c) {
            case '*': 
            case '+': 
            case '.': 
            case '?': {
                this.add(new RawChar(c, this));
                bl = true;
                break;
            }
            case '-': {
                this.ongoingRange = true;
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void add(@NotNull RegexNode b) {
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        if (!this.ongoingRange) {
            super.add(b);
        } else {
            RegexNode previous = (RegexNode)CollectionsKt.last(this.getChildren$library());
            RegexNode range = this.buildRange(previous, b);
            if (range != null) {
                this.getChildren$library().remove(previous);
                this.getChildren$library().add(range);
            }
            this.ongoingRange = false;
        }
    }

    @Override
    public void describe(@NotNull StringBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        builder.append("[");
        super.describe(builder);
        builder.append("]");
    }

    @Override
    public void buildIteration(@NotNull Forger forger, @NotNull StringBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)forger, (String)"forger");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        RegexNode node = forger.anElementFrom(this.getChildren$library());
        node.buildIteration(forger, builder);
    }

    private final RegexNode buildRange(RegexNode from, RegexNode to) {
        char toChar;
        if (!(from instanceof RawChar)) {
            return null;
        }
        if (!(to instanceof RawChar)) {
            return null;
        }
        char fromChar = ((RawChar)from).getRawChar();
        if (fromChar >= (toChar = ((RawChar)to).getRawChar())) {
            return null;
        }
        if (ArraysKt.contains((char[])Forger.ALPHA_LOWER, (char)fromChar) & !ArraysKt.contains((char[])Forger.ALPHA_LOWER, (char)toChar)) {
            return null;
        }
        if (ArraysKt.contains((char[])Forger.ALPHA_UPPER, (char)fromChar) & !ArraysKt.contains((char[])Forger.ALPHA_UPPER, (char)toChar)) {
            return null;
        }
        if (ArraysKt.contains((char[])Forger.DIGIT, (char)fromChar) & !ArraysKt.contains((char[])Forger.DIGIT, (char)toChar)) {
            return null;
        }
        return new RegexCharRangeNode(fromChar, toChar, this);
    }

    public RegexChoiceNode(@Nullable RegexParentNode parent) {
        super(parent);
    }

    public /* synthetic */ RegexChoiceNode(RegexParentNode regexParentNode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            regexParentNode = null;
        }
        this(regexParentNode);
    }

    public RegexChoiceNode() {
        this(null, 1, null);
    }
}

