/*
 * Decompiled with CFR 0.152.
 */
package fr.xgouchet.elmyr.regex;

import fr.xgouchet.elmyr.Forger;
import fr.xgouchet.elmyr.regex.Quantifier;
import fr.xgouchet.elmyr.regex.RawChar;
import fr.xgouchet.elmyr.regex.RegexChoiceNode;
import fr.xgouchet.elmyr.regex.RegexDigitCharNode;
import fr.xgouchet.elmyr.regex.RegexGroupNode;
import fr.xgouchet.elmyr.regex.RegexNonDigitCharNode;
import fr.xgouchet.elmyr.regex.RegexNonWhitespaceNode;
import fr.xgouchet.elmyr.regex.RegexNonWordCharNode;
import fr.xgouchet.elmyr.regex.RegexOrNode;
import fr.xgouchet.elmyr.regex.RegexParentNode;
import fr.xgouchet.elmyr.regex.RegexRangeNode;
import fr.xgouchet.elmyr.regex.RegexWhitespaceNode;
import fr.xgouchet.elmyr.regex.RegexWildcardNode;
import fr.xgouchet.elmyr.regex.RegexWordCharNode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lfr/xgouchet/elmyr/regex/RegexBuilder;", "", "regex", "", "(Ljava/lang/String;)V", "escapeNext", "", "ongoingNode", "Lfr/xgouchet/elmyr/regex/RegexParentNode;", "rootNode", "buildString", "forger", "Lfr/xgouchet/elmyr/Forger;", "handleCharacter", "", "c", "", "handleEscapedCharacter", "parse", "library"})
public final class RegexBuilder {
    private RegexParentNode rootNode;
    private RegexParentNode ongoingNode;
    private boolean escapeNext;

    private final void parse(String regex) {
        String string;
        String string2 = string = regex;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string2.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        for (char c : cArray) {
            if (this.escapeNext) {
                this.handleEscapedCharacter(c);
                this.escapeNext = false;
                continue;
            }
            this.handleCharacter(c);
        }
    }

    private final void handleEscapedCharacter(char c) {
        switch (c) {
            case 's': {
                this.ongoingNode.add(new RegexWhitespaceNode(this.ongoingNode));
                break;
            }
            case 'S': {
                this.ongoingNode.add(new RegexNonWhitespaceNode(this.ongoingNode));
                break;
            }
            case 'w': {
                this.ongoingNode.add(new RegexWordCharNode(this.ongoingNode));
                break;
            }
            case 'd': {
                this.ongoingNode.add(new RegexDigitCharNode(this.ongoingNode));
                break;
            }
            case 'W': {
                this.ongoingNode.add(new RegexNonWordCharNode(this.ongoingNode));
                break;
            }
            case 'D': {
                this.ongoingNode.add(new RegexNonDigitCharNode(this.ongoingNode));
                break;
            }
            case 'n': {
                this.ongoingNode.add(new RawChar('\n', this.ongoingNode));
                break;
            }
            case 't': {
                this.ongoingNode.add(new RawChar('\t', this.ongoingNode));
                break;
            }
            case '!': 
            case '$': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                this.ongoingNode.add(new RawChar(c, this.ongoingNode));
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Can't escape \u2018" + c + '\u2019');
            }
        }
    }

    private final void handleCharacter(char c) {
        if (this.ongoingNode.handle(c)) {
            return;
        }
        switch (c) {
            case '.': {
                this.ongoingNode.add(new RegexWildcardNode(this.ongoingNode));
                break;
            }
            case '?': {
                this.ongoingNode.updateLastElementQuantfier(Quantifier.Companion.getMAYBE_ONE());
                break;
            }
            case '*': {
                this.ongoingNode.updateLastElementQuantfier(Quantifier.Companion.getZERO_OR_MORE());
                break;
            }
            case '+': {
                this.ongoingNode.updateLastElementQuantfier(Quantifier.Companion.getONE_OR_MORE());
                break;
            }
            case '[': {
                RegexChoiceNode choice = new RegexChoiceNode(this.ongoingNode);
                this.ongoingNode.add(choice);
                this.ongoingNode = choice;
                break;
            }
            case ']': {
                RegexParentNode regexParentNode = this.ongoingNode.getParent();
                if (regexParentNode == null) {
                    throw (Throwable)new IllegalStateException();
                }
                this.ongoingNode = regexParentNode;
                break;
            }
            case '(': {
                RegexGroupNode group = new RegexGroupNode(this.ongoingNode);
                this.ongoingNode.add(group);
                RegexParentNode sequence = new RegexParentNode(group);
                group.add(sequence);
                this.ongoingNode = sequence;
                break;
            }
            case ')': {
                do {
                    if (this.ongoingNode.getParent() == null) {
                        throw (Throwable)new IllegalStateException();
                    }
                    this.ongoingNode = this.ongoingNode;
                } while (!(this.ongoingNode instanceof RegexGroupNode));
                RegexParentNode regexParentNode = this.ongoingNode.getParent();
                if (regexParentNode == null) {
                    throw (Throwable)new IllegalStateException();
                }
                this.ongoingNode = regexParentNode;
                break;
            }
            case '{': {
                RegexRangeNode group = new RegexRangeNode(this.ongoingNode);
                this.ongoingNode = group;
                break;
            }
            case '}': {
                RegexParentNode regexParentNode = this.ongoingNode;
                if (!(regexParentNode instanceof RegexRangeNode)) {
                    regexParentNode = null;
                }
                RegexRangeNode regexRangeNode = (RegexRangeNode)regexParentNode;
                if (regexRangeNode == null) {
                    throw (Throwable)new IllegalStateException("Expecting to be reading a range");
                }
                RegexRangeNode rangeNode = regexRangeNode;
                Quantifier rangeQuantifier = rangeNode.toQuantifier();
                RegexParentNode regexParentNode2 = this.ongoingNode.getParent();
                if (regexParentNode2 == null) {
                    throw (Throwable)new IllegalStateException();
                }
                this.ongoingNode = regexParentNode2;
                this.ongoingNode.updateLastElementQuantfier(rangeQuantifier);
                break;
            }
            case '|': {
                if (this.ongoingNode.getParent() instanceof RegexOrNode) {
                    RegexParentNode next = new RegexParentNode(this.ongoingNode.getParent());
                    RegexParentNode regexParentNode = this.ongoingNode.getParent();
                    if (regexParentNode != null) {
                        regexParentNode.add(next);
                    }
                    this.ongoingNode = next;
                    break;
                }
                RegexOrNode orNode = new RegexOrNode(this.ongoingNode.getParent());
                orNode.add(this.ongoingNode);
                RegexParentNode regexParentNode = this.ongoingNode.getParent();
                if (regexParentNode != null) {
                    RegexParentNode rangeQuantifier;
                    RegexParentNode it = rangeQuantifier = regexParentNode;
                    it.add(orNode);
                }
                if (Intrinsics.areEqual((Object)this.ongoingNode, (Object)this.rootNode)) {
                    this.rootNode = orNode;
                } else if (Intrinsics.areEqual((Object)this.ongoingNode.getParent(), (Object)this.rootNode)) {
                    this.rootNode = orNode;
                }
                RegexParentNode next = new RegexParentNode(orNode);
                orNode.add(next);
                RegexParentNode regexParentNode3 = this.ongoingNode.getParent();
                if (regexParentNode3 != null) {
                    RegexParentNode regexParentNode4;
                    RegexParentNode it = regexParentNode4 = regexParentNode3;
                    it.remove(this.ongoingNode);
                }
                this.ongoingNode.setParent(orNode);
                this.ongoingNode = next;
                break;
            }
            case '\\': {
                this.escapeNext = true;
                break;
            }
            default: {
                this.ongoingNode.add(new RawChar(c, this.ongoingNode));
            }
        }
    }

    @NotNull
    public final String buildString(@NotNull Forger forger) {
        Intrinsics.checkParameterIsNotNull((Object)forger, (String)"forger");
        StringBuilder builder = new StringBuilder();
        this.rootNode.build(forger, builder);
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    public RegexBuilder(@NotNull String regex) {
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        this.ongoingNode = this.rootNode = new RegexParentNode(null, 1, null);
        this.parse(regex);
    }
}

