/*
 * Decompiled with CFR 0.152.
 */
package fr.xgouchet.elmyr.junit;

import fr.xgouchet.elmyr.junit.Repeat;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lfr/xgouchet/elmyr/junit/Repeater;", "Lorg/junit/rules/TestRule;", "()V", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "RepeaterStatement", "library"})
public final class Repeater
implements TestRule {
    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        return new RepeaterStatement(base, description);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lfr/xgouchet/elmyr/junit/Repeater$RepeaterStatement;", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "(Lorg/junit/runners/model/Statement;Lorg/junit/runner/Description;)V", "evaluate", "", "evaluateRepeated", "Lkotlin/Pair;", "", "", "count", "", "library"})
    public static final class RepeaterStatement
    extends Statement {
        private final Statement base;
        private final Description description;

        /*
         * WARNING - void declaration
         */
        public void evaluate() throws Throwable {
            void errors;
            Repeat repeat;
            Repeat repeat2 = repeat = (Repeat)this.description.getAnnotation(Repeat.class);
            int count = repeat2 != null ? repeat2.count() : 1;
            Repeat repeat3 = repeat;
            int failureThreshold = repeat3 != null ? repeat3.failureThreshold() : 0;
            Repeat repeat4 = repeat;
            int ignoreThreshold = repeat4 != null ? repeat4.ignoreThreshold() : 0;
            Pair<List<Throwable>, List<Throwable>> pair = this.evaluateRepeated(count);
            List list = (List)pair.component1();
            List ignores = (List)pair.component2();
            if (errors.size() > failureThreshold) {
                throw (Throwable)new MultipleFailureException((List)errors);
            }
            if (ignores.size() > ignoreThreshold) {
                String msg = ignores.size() + "(over " + repeat.count() + ") iteration(s) were ignored for " + this.description.getDisplayName();
                throw (Throwable)new AssumptionViolatedException(msg);
            }
        }

        private final Pair<List<Throwable>, List<Throwable>> evaluateRepeated(int count) {
            List errors = new ArrayList();
            List ignores = new ArrayList();
            int n = count;
            for (int i = 0; i < n; ++i) {
                int it = i;
                try {
                    this.base.evaluate();
                    continue;
                }
                catch (AssumptionViolatedException e) {
                    ignores.add(e);
                    continue;
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
            return new Pair((Object)errors, (Object)ignores);
        }

        public RepeaterStatement(@NotNull Statement base, @NotNull Description description) {
            Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
            Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
            this.base = base;
            this.description = description;
        }
    }
}

