/*
 * Decompiled with CFR 0.152.
 */
package com.cheese.geeksone;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import com.cheese.geeksone.Container;
import com.cheese.geeksone.Mode;
import com.cheese.geeksone.OnCancelledListener;
import com.cheese.geeksone.OnResultListener;
import com.cheese.geeksone.Utils;
import com.cheese.geeksone.lib.HttpRequest;
import com.google.gson.GsonBuilder;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeoutException;
import org.json.JSONObject;

public class Geeksone {
    Context mContext;
    Object mRequest;
    Container mContainer;
    HttpRequest mHttpRequest;
    Mode mRequestMode;
    OnResultListener mResultListener;
    OnCancelledListener mCancelledListener;
    String mURL;
    String mResponse;
    int mTimeout = 5000;

    public Geeksone(Context context) {
        this.mContext = context;
    }

    public Geeksone GET(String url) {
        this.mURL = url;
        this.mRequestMode = Mode.GET;
        this.mContainer = new Container(url).setMode(Mode.GET);
        this.setOnResultListener(this.mContainer.getOnResult());
        this.setOnCancelledListener(this.mContainer.getOnCancelled());
        this.start();
        return this;
    }

    public Geeksone POST(String url, Object obj) {
        this.mURL = url;
        this.mRequestMode = Mode.POST;
        this.mRequest = obj;
        this.mContainer = new Container(url).setRequestBody(obj).setMode(Mode.POST);
        this.setOnResultListener(this.mContainer.getOnResult());
        this.setOnCancelledListener(this.mContainer.getOnCancelled());
        this.start();
        return this;
    }

    public Geeksone GET(Container container) {
        this.mContainer = container;
        this.mURL = container.getURL();
        this.mRequestMode = Mode.GET;
        this.mContainer.setMode(this.mRequestMode);
        this.setOnResultListener(this.mContainer.getOnResult());
        this.setOnCancelledListener(this.mContainer.getOnCancelled());
        this.start();
        return this;
    }

    public Geeksone POST(Container container) {
        this.mContainer = container;
        this.mURL = container.getURL();
        this.mRequest = container.getRequestBody();
        this.mRequestMode = Mode.POST;
        this.mContainer.setMode(this.mRequestMode);
        this.setOnResultListener(this.mContainer.getOnResult());
        this.setOnCancelledListener(this.mContainer.getOnCancelled());
        this.start();
        return this;
    }

    public Geeksone setTimeout(int timeoutInMs) {
        this.mTimeout = timeoutInMs;
        return this;
    }

    private void setOnResultListener(OnResultListener listener) {
        this.mResultListener = listener;
    }

    private void setOnCancelledListener(OnCancelledListener listener) {
        this.mCancelledListener = listener;
    }

    public HttpRequest getHttpRequest() {
        return this.mHttpRequest;
    }

    public Geeksone setHttpRequest(HttpRequest req) {
        this.mHttpRequest = req;
        return this;
    }

    public Geeksone RETRY(Container c) {
        if (c.getMode() == Mode.GET) {
            this.GET(c);
        }
        if (c.getMode() == Mode.POST) {
            this.POST(c);
        }
        return this;
    }

    private void built() {
        this.mHttpRequest = null;
        if (this.mRequestMode == Mode.GET) {
            this.mHttpRequest = HttpRequest.get(this.mURL).readTimeout(this.mTimeout).connectTimeout(this.mTimeout);
        }
        if (this.mRequestMode == Mode.POST) {
            this.mHttpRequest = HttpRequest.post(this.mURL).contentType("application/json").send(this.getRequest(this.mRequest));
        }
        if (this.mRequestMode == Mode.PUT) {
            this.mHttpRequest = HttpRequest.put(this.mURL).contentType("application/json").send(this.getRequest(this.mRequest)).readTimeout(this.mTimeout).connectTimeout(this.mTimeout);
        }
        if (this.mRequestMode == Mode.DELETE) {
            this.mHttpRequest = HttpRequest.delete(this.mURL).contentType("application/json").send(this.getRequest(this.mRequest));
        }
        if (this.mHttpRequest != null) {
            if (this.mContainer.getHeader() != null) {
                this.mHttpRequest.headers(this.mContainer.getHeader());
            }
            if (this.mContainer.hasBasic()) {
                this.mHttpRequest.basic(this.mContainer.BasicUsername(), this.mContainer.BasicPassword());
            }
            this.mHttpRequest.readTimeout(this.mTimeout).connectTimeout(this.mTimeout);
        } else {
            this.PokeOnError(new Exception("Unsupported REST Mode"));
        }
    }

    private void start() {
        new AsyncTask<Void, Void, Boolean>(){

            protected Boolean doInBackground(Void ... params) {
                if (Geeksone.this.mResultListener == null) {
                    Geeksone.this.PokeOnError(new Exception("OnResultListener cannot be null"));
                    return false;
                }
                if (Utils.HasConnectivity(Geeksone.this.mContext)) {
                    try {
                        Geeksone.this.mResponse = Geeksone.this.mHttpRequest.body();
                        return true;
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof ConnectException || e.getCause() instanceof TimeoutException || e.getCause() instanceof SocketTimeoutException) {
                            Geeksone.this.PokeOnConnectionTimeOut(e);
                        } else {
                            Geeksone.this.PokeOnError(e);
                        }
                        e.printStackTrace();
                        return false;
                    }
                }
                Exception cep = new Exception("No connectivity found");
                Geeksone.this.PokeOnError(cep);
                return false;
            }

            protected void onPreExecute() {
                super.onPreExecute();
                try {
                    Geeksone.this.built();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Geeksone.this.PokeOnError(ex);
                }
                if (Geeksone.this.mRequest == null && Geeksone.this.mRequestMode == Mode.POST) {
                    Geeksone.this.PokeOnError(new NullPointerException("POST must given Request Body"));
                }
                if (Geeksone.this.getRequest(Geeksone.this.mRequest) == null) {
                    Geeksone.this.PokeOnError(new NullPointerException("Unable to handle type of Request Body"));
                }
            }

            protected void onPostExecute(Boolean aBoolean) {
                super.onPostExecute((Object)aBoolean);
                if (aBoolean.booleanValue()) {
                    if (Geeksone.this.getResponse() == null) {
                        Geeksone.this.PokeOnError(new Exception("Response is null"));
                        Geeksone.this.mResultListener.OnResult(false, Geeksone.this.mContainer, Geeksone.this);
                    } else if (Geeksone.this.getJSON() == null) {
                        Geeksone.this.PokeOnError(new Exception("Response is null or not a Valid JSON"));
                        Geeksone.this.mResultListener.OnResult(false, Geeksone.this.mContainer, Geeksone.this);
                    } else {
                        Geeksone.this.mResultListener.OnResult(true, Geeksone.this.mContainer, Geeksone.this);
                    }
                }
            }
        }.execute((Object[])new Void[0]);
    }

    private void PokeOnError(final Exception ex) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (Geeksone.this.mCancelledListener != null) {
                    Geeksone.this.mCancelledListener.OnCancelled(ex, false, Geeksone.this.mContainer, Geeksone.this);
                }
                if (Geeksone.this.mResultListener != null) {
                    Geeksone.this.mResultListener.OnResult(false, Geeksone.this.mContainer, Geeksone.this);
                }
            }
        });
    }

    private void PokeOnConnectionTimeOut(final Exception ex) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (Geeksone.this.mCancelledListener != null) {
                    Geeksone.this.mCancelledListener.OnCancelled(ex, true, Geeksone.this.mContainer, Geeksone.this);
                }
                if (Geeksone.this.mResultListener != null) {
                    Geeksone.this.mResultListener.OnResult(false, Geeksone.this.mContainer, Geeksone.this);
                }
            }
        });
    }

    public String getRequest(Object obj) {
        if (this.mRequest instanceof JSONObject) {
            return ((JSONObject)obj).toString();
        }
        if (this.mRequest instanceof String) {
            return (String)obj;
        }
        return new GsonBuilder().create().toJson(obj);
    }

    public String getResponse() {
        return this.mResponse;
    }

    public String getJSON() {
        if (this.mResponse == null) {
            return null;
        }
        if (Utils.IsValidJSON(this.mResponse)) {
            return this.mResponse;
        }
        return null;
    }

    public <T> T getClazz(Class<T> clazz) {
        if (this.getJSON() != null) {
            try {
                return (T)new GsonBuilder().create().fromJson(this.getJSON(), clazz);
            }
            catch (Exception ex) {
                this.PokeOnError(ex);
                return null;
            }
        }
        this.PokeOnError(new Exception("Response is null"));
        return null;
    }

    public Container getContainer() {
        return this.mContainer;
    }
}

