/*
 * Decompiled with CFR 0.152.
 */
package com.github.wvengen.maven.proguard;

import com.github.wvengen.maven.proguard.Assembly;
import com.github.wvengen.maven.proguard.Exclusion;
import com.github.wvengen.maven.proguard.Inclusion;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProGuardMojo
extends AbstractMojo {
    private boolean skip;
    private File proguardInclude;
    private String proguardVersion;
    private boolean useDexGuard;
    private String[] options;
    private boolean obfuscate;
    private boolean includeDependency;
    private File tempLibraryjarsDir;
    private boolean putLibraryJarsInTempDir;
    private boolean includeDependencyInjar;
    private Assembly assembly;
    private List<String> libs;
    private List<Exclusion> exclusions;
    protected String injar;
    private boolean injarNotExistsSkip;
    protected String inFilter;
    protected String outjar;
    protected String outFilter;
    private boolean attach;
    private boolean attachMap;
    private boolean attachSeed;
    private String attachArtifactType;
    private String attachArtifactClassifier;
    private boolean appendClassifier;
    private boolean addMavenDescriptor;
    protected File outputDirectory;
    protected MavenProject mavenProject;
    protected List<Artifact> pluginArtifacts;
    private MavenProjectHelper projectHelper;
    private JarArchiver jarArchiver;
    protected MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    protected String maxMemory;
    protected String proguardMainClass = "proguard.ProGuard";
    protected String mappingFileName = "proguard_map.txt";
    protected String seedFileName = "proguard_seeds.txt";
    protected File proguardJar;
    private boolean silent;
    private Log log;

    private String fileNameToString(String fileName) {
        return "'" + fileName + "'";
    }

    private String fileToString(File file) {
        return this.fileNameToString(file.toString());
    }

    private boolean useArtifactClassifier() {
        return this.appendClassifier && this.attachArtifactClassifier != null && this.attachArtifactClassifier.length() > 0;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Iterator filter;
        File file;
        File outJarFile;
        boolean sameArtifact;
        this.log = this.getLog();
        if (this.skip) {
            this.log.info((CharSequence)"Bypass ProGuard processing because \"proguard.skip=true\"");
            return;
        }
        boolean mainIsJar = this.mavenProject.getPackaging().equals("jar");
        File inJarFile = new File(this.outputDirectory, this.injar);
        if (!inJarFile.exists()) {
            if (this.injarNotExistsSkip) {
                this.log.info((CharSequence)"Bypass ProGuard processing because \"injar\" dos not exist");
                return;
            }
            if (mainIsJar) {
                throw new MojoFailureException("Can't find file " + inJarFile);
            }
        }
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new MojoFailureException("Can't create " + this.outputDirectory);
        }
        if (this.attach) {
            this.outjar = this.nameNoType(this.injar);
            if (this.useArtifactClassifier()) {
                this.outjar = this.outjar + "-" + this.attachArtifactClassifier;
            }
            this.outjar = this.outjar + "." + this.attachArtifactType;
        }
        if (this.outjar != null && !this.outjar.equals(this.injar)) {
            sameArtifact = false;
            outJarFile = new File(this.outputDirectory, this.outjar).getAbsoluteFile();
            if (outJarFile.exists() && !this.deleteFileOrDirectory(outJarFile)) {
                throw new MojoFailureException("Can't delete " + outJarFile);
            }
        } else {
            sameArtifact = true;
            outJarFile = inJarFile.getAbsoluteFile();
            File baseFile = inJarFile.isDirectory() ? new File(this.outputDirectory, this.nameNoType(this.injar) + "_proguard_base") : new File(this.outputDirectory, this.nameNoType(this.injar) + "_proguard_base.jar");
            if (baseFile.exists() && !this.deleteFileOrDirectory(baseFile)) {
                throw new MojoFailureException("Can't delete " + baseFile);
            }
            if (inJarFile.exists() && !inJarFile.renameTo(baseFile)) {
                throw new MojoFailureException("Can't rename " + inJarFile);
            }
            inJarFile = baseFile;
        }
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<File> libraryJars = new ArrayList<File>();
        if (this.log.isDebugEnabled()) {
            List dependancy = this.mavenProject.getCompileArtifacts();
            for (Object artifact : dependancy) {
                this.log.debug((CharSequence)("--- compile artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getClassifier() + " Scope:" + artifact.getScope()));
            }
            Set artifacts = this.mavenProject.getArtifacts();
            for (Object artifact : artifacts) {
                this.log.debug((CharSequence)("--- artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getClassifier() + " Scope:" + artifact.getScope()));
            }
            List dependencies = this.mavenProject.getDependencies();
            for (Artifact artifact : dependencies) {
                this.log.debug((CharSequence)("--- dependency " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getClassifier() + " Scope:" + artifact.getScope()));
            }
        }
        HashSet<String> inPath = new HashSet<String>();
        boolean hasInclusionLibrary = false;
        if (this.assembly != null && this.assembly.inclusions != null) {
            List inclusions = this.assembly.inclusions;
            for (Inclusion inc : inclusions) {
                if (!inc.library) {
                    file = this.getClasspathElement(this.getDependency(inc, this.mavenProject), this.mavenProject);
                    inPath.add(file.toString());
                    this.log.debug((CharSequence)("--- ADD injars:" + inc.artifactId));
                    StringBuilder filter2 = new StringBuilder(this.fileToString(file));
                    filter2.append("(!META-INF/MANIFEST.MF");
                    if (!this.addMavenDescriptor) {
                        filter2.append(",");
                        filter2.append("!META-INF/maven/**");
                    }
                    if (inc.filter != null) {
                        filter2.append(",").append(inc.filter);
                    }
                    filter2.append(")");
                    args.add("-injars");
                    args.add(filter2.toString());
                    continue;
                }
                hasInclusionLibrary = true;
                this.log.debug((CharSequence)("--- ADD libraryjars:" + inc.artifactId));
                file = this.getClasspathElement(this.getDependency(inc, this.mavenProject), this.mavenProject);
                inPath.add(file.toString());
                if (this.putLibraryJarsInTempDir) {
                    libraryJars.add(file);
                    continue;
                }
                args.add("-libraryjars");
                args.add(this.fileToString(file));
            }
        }
        if (inJarFile.exists()) {
            args.add("-injars");
            filter = new StringBuilder(this.fileToString(inJarFile));
            if (this.inFilter != null || !this.addMavenDescriptor) {
                ((StringBuilder)((Object)filter)).append("(");
                boolean coma = false;
                if (!this.addMavenDescriptor) {
                    coma = true;
                    ((StringBuilder)((Object)filter)).append("!META-INF/maven/**");
                }
                if (this.inFilter != null) {
                    if (coma) {
                        ((StringBuilder)((Object)filter)).append(",");
                    }
                    ((StringBuilder)((Object)filter)).append(this.inFilter);
                }
                ((StringBuilder)((Object)filter)).append(")");
            }
            args.add(((StringBuilder)((Object)filter)).toString());
        }
        if (this.includeDependency) {
            List dependency = this.mavenProject.getCompileArtifacts();
            for (Artifact artifact : dependency) {
                if (this.isExclusion(artifact)) continue;
                file = this.getClasspathElement(artifact, this.mavenProject);
                if (inPath.contains(file.toString())) {
                    this.log.debug((CharSequence)("--- ignore library since one in injar:" + artifact.getArtifactId()));
                    continue;
                }
                if (this.includeDependencyInjar) {
                    this.log.debug((CharSequence)("--- ADD library as injars:" + artifact.getArtifactId()));
                    args.add("-injars");
                    args.add(this.fileToString(file));
                    continue;
                }
                this.log.debug((CharSequence)("--- ADD libraryjars:" + artifact.getArtifactId()));
                if (this.putLibraryJarsInTempDir) {
                    libraryJars.add(file);
                    continue;
                }
                args.add("-libraryjars");
                args.add(this.fileToString(file));
            }
        }
        if (args.contains("-injars")) {
            args.add("-outjars");
            filter = new StringBuilder(this.fileToString(outJarFile));
            if (this.outFilter != null) {
                ((StringBuilder)((Object)filter)).append("(").append(this.outFilter).append(")");
            }
            args.add(((StringBuilder)((Object)filter)).toString());
        }
        if (!this.obfuscate) {
            args.add("-dontobfuscate");
        }
        if (this.proguardInclude != null) {
            if (this.proguardInclude.exists()) {
                args.add("-include");
                args.add(this.fileToString(this.proguardInclude));
                this.log.debug((CharSequence)("proguardInclude " + this.proguardInclude));
            } else {
                this.log.debug((CharSequence)("proguardInclude config does not exists " + this.proguardInclude));
            }
        }
        if (this.libs != null) {
            for (String lib : this.libs) {
                if (this.putLibraryJarsInTempDir) {
                    libraryJars.add(new File(lib));
                    continue;
                }
                args.add("-libraryjars");
                args.add(this.fileNameToString(lib));
            }
        }
        if (!libraryJars.isEmpty()) {
            this.log.debug((CharSequence)"Copy libraryJars to temporary directory");
            this.log.debug((CharSequence)("Temporary directory: " + this.tempLibraryjarsDir));
            if (this.tempLibraryjarsDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)this.tempLibraryjarsDir);
                }
                catch (IOException filter3) {
                    // empty catch block
                }
            }
            this.tempLibraryjarsDir.mkdir();
            if (!this.tempLibraryjarsDir.exists()) {
                throw new MojoFailureException("Can't create temporary libraryJars directory: " + this.tempLibraryjarsDir.getAbsolutePath());
            }
            for (File libraryJar : libraryJars) {
                try {
                    FileUtils.copyFileToDirectory((File)libraryJar, (File)this.tempLibraryjarsDir);
                }
                catch (IOException e) {
                    throw new MojoFailureException("Can't copy to temporary libraryJars directory", (Throwable)e);
                }
            }
            args.add("-libraryjars");
            args.add(this.fileToString(this.tempLibraryjarsDir));
        }
        args.add("-printmapping");
        args.add(this.fileToString(new File(this.outputDirectory, this.mappingFileName).getAbsoluteFile()));
        args.add("-printseeds");
        args.add(this.fileToString(new File(this.outputDirectory, this.seedFileName).getAbsoluteFile()));
        if (this.log.isDebugEnabled()) {
            args.add("-verbose");
        }
        if (this.options != null) {
            Collections.addAll(args, this.options);
        }
        this.log.info((CharSequence)("execute ProGuard " + args.toString()));
        this.proguardMain(this.getProguardJar(this), args, this);
        if (!libraryJars.isEmpty()) {
            this.deleteFileOrDirectory(this.tempLibraryjarsDir);
        }
        if (this.assembly != null && hasInclusionLibrary) {
            this.log.info((CharSequence)"creating assembly");
            File baseFile = new File(this.outputDirectory, this.nameNoType(this.injar) + "_proguard_result.jar");
            if (baseFile.exists() && !baseFile.delete()) {
                throw new MojoFailureException("Can't delete " + baseFile);
            }
            File archiverFile = outJarFile.getAbsoluteFile();
            if (!outJarFile.renameTo(baseFile)) {
                throw new MojoFailureException("Can't rename " + outJarFile);
            }
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            archiver.setOutputFile(archiverFile);
            this.archive.setAddMavenDescriptor(this.addMavenDescriptor);
            try {
                this.jarArchiver.addArchivedFileSet(baseFile);
                List inclusions = this.assembly.inclusions;
                for (Inclusion inc : inclusions) {
                    if (!inc.library) continue;
                    Artifact artifact = this.getDependency(inc, this.mavenProject);
                    File file2 = this.getClasspathElement(artifact, this.mavenProject);
                    if (file2.isDirectory()) {
                        this.getLog().info((CharSequence)("merge project: " + artifact.getArtifactId() + " " + file2));
                        this.jarArchiver.addDirectory(file2);
                        continue;
                    }
                    this.getLog().info((CharSequence)("merge artifact: " + artifact.getArtifactId()));
                    this.jarArchiver.addArchivedFileSet(file2);
                }
                archiver.createArchive(this.mavenProject, this.archive);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to create jar", e);
            }
        }
        if (this.attach) {
            if (!sameArtifact) {
                String classifier = this.useArtifactClassifier() ? this.attachArtifactClassifier : null;
                this.projectHelper.attachArtifact(this.mavenProject, this.attachArtifactType, classifier, outJarFile);
            }
            String mainClassifier = this.useArtifactClassifier() ? this.attachArtifactClassifier : null;
            File buildOutput = new File(this.mavenProject.getBuild().getDirectory());
            if (this.attachMap) {
                this.attachTextFile(new File(buildOutput, this.mappingFileName), mainClassifier, "map");
            }
            if (this.attachSeed) {
                this.attachTextFile(new File(buildOutput, this.seedFileName), mainClassifier, "seed");
            }
        }
    }

    private void attachTextFile(File theFile, String mainClassifier, String suffix) {
        String classifier = (null == mainClassifier ? "" : mainClassifier + "-") + suffix;
        this.log.info((CharSequence)("Attempting to attach " + suffix + " artifact"));
        if (theFile.exists()) {
            if (theFile.isFile()) {
                this.projectHelper.attachArtifact(this.mavenProject, "txt", classifier, theFile);
            } else {
                this.log.warn((CharSequence)("Cannot attach file because it is not a file: " + theFile));
            }
        } else {
            this.log.warn((CharSequence)("Cannot attach file because it does not exist: " + theFile));
        }
    }

    private File getProguardJar(ProGuardMojo mojo) throws MojoExecutionException {
        if (this.proguardJar != null) {
            if (this.proguardJar.exists()) {
                if (this.proguardJar.isFile()) {
                    return this.proguardJar;
                }
                mojo.getLog().warn((CharSequence)("proguard jar (" + this.proguardJar + ") is not a file"));
                throw new MojoExecutionException("proguard jar (" + this.proguardJar + ") is not a file");
            }
            mojo.getLog().warn((CharSequence)("proguard jar (" + this.proguardJar + ") does not exist"));
            throw new MojoExecutionException("proguard jar (" + this.proguardJar + ") does not exist");
        }
        Artifact proguardArtifact = null;
        int proguardArtifactDistance = -1;
        for (Artifact artifact : mojo.pluginArtifacts) {
            mojo.getLog().debug((CharSequence)("pluginArtifact: " + artifact.getFile()));
            String artifactId = artifact.getArtifactId();
            if (!artifactId.startsWith(this.useDexGuard ? "dexguard" : "proguard") || artifactId.startsWith("proguard-maven-plugin")) continue;
            int distance = artifact.getDependencyTrail().size();
            mojo.getLog().debug((CharSequence)("proguard DependencyTrail: " + distance));
            if (mojo.proguardVersion != null && mojo.proguardVersion.equals(artifact.getVersion())) {
                proguardArtifact = artifact;
                break;
            }
            if (proguardArtifactDistance == -1) {
                proguardArtifact = artifact;
                proguardArtifactDistance = distance;
                continue;
            }
            if (distance >= proguardArtifactDistance) continue;
            proguardArtifact = artifact;
            proguardArtifactDistance = distance;
        }
        if (proguardArtifact != null) {
            mojo.getLog().debug((CharSequence)("proguardArtifact: " + proguardArtifact.getFile()));
            return proguardArtifact.getFile().getAbsoluteFile();
        }
        mojo.getLog().info((CharSequence)((this.useDexGuard ? "dexguard" : "proguard") + " jar not found in pluginArtifacts"));
        ClassLoader cl = ((Object)((Object)mojo)).getClass().getClassLoader();
        String classResource = "/" + mojo.proguardMainClass.replace('.', '/') + ".class";
        URL url = cl.getResource(classResource);
        if (url == null) {
            throw new MojoExecutionException("Obfuscation failed ProGuard (" + mojo.proguardMainClass + ") not found in classpath");
        }
        String proguardJar = url.toExternalForm();
        if (!proguardJar.startsWith("jar:file:")) {
            throw new MojoExecutionException("Unrecognized location (" + proguardJar + ") in classpath");
        }
        proguardJar = proguardJar.substring("jar:file:".length());
        proguardJar = proguardJar.substring(0, proguardJar.indexOf(33));
        return new File(proguardJar);
    }

    private void proguardMain(File proguardJar, List<String> argsList, ProGuardMojo mojo) throws MojoExecutionException {
        Java java = new Java();
        Project antProject = new Project();
        antProject.setName(mojo.mavenProject.getName());
        antProject.init();
        DefaultLogger antLogger = new DefaultLogger();
        antLogger.setOutputPrintStream(System.out);
        antLogger.setErrorPrintStream(System.err);
        int logLevel = mojo.log.isDebugEnabled() ? 4 : 2;
        antLogger.setMessageOutputLevel(this.silent ? 0 : logLevel);
        antProject.addBuildListener((BuildListener)antLogger);
        antProject.setBaseDir(mojo.mavenProject.getBasedir());
        java.setProject(antProject);
        java.setTaskName("proguard");
        mojo.getLog().info((CharSequence)("proguard jar: " + proguardJar));
        java.createClasspath().setLocation(proguardJar);
        java.setClassname(mojo.proguardMainClass);
        java.setFailonerror(true);
        java.setFork(true);
        if (mojo.maxMemory != null) {
            java.setMaxmemory(mojo.maxMemory);
        }
        for (String arg : argsList) {
            java.createArg().setValue(arg);
        }
        int result = java.executeJava();
        if (result != 0) {
            throw new MojoExecutionException("Obfuscation failed (result=" + result + ")");
        }
    }

    private String nameNoType(String fileName) {
        int extStart = fileName.lastIndexOf(46);
        if (extStart == -1) {
            return fileName;
        }
        return fileName.substring(0, extStart);
    }

    private boolean deleteFileOrDirectory(File path) throws MojoFailureException {
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            if (null != files) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        if (this.deleteFileOrDirectory(file)) continue;
                        throw new MojoFailureException("Can't delete dir " + file);
                    }
                    if (file.delete()) continue;
                    throw new MojoFailureException("Can't delete file " + file);
                }
            }
            return path.delete();
        }
        return path.delete();
    }

    private Artifact getDependency(Inclusion inc, MavenProject mavenProject) throws MojoExecutionException {
        Set dependency = mavenProject.getArtifacts();
        for (Artifact artifact : dependency) {
            if (!inc.match(artifact)) continue;
            return artifact;
        }
        throw new MojoExecutionException("artifactId Not found " + inc.artifactId);
    }

    private boolean isExclusion(Artifact artifact) {
        if (this.exclusions == null) {
            return false;
        }
        for (Exclusion excl : this.exclusions) {
            if (!excl.match(artifact)) continue;
            return true;
        }
        return false;
    }

    private File getClasspathElement(Artifact artifact, MavenProject mavenProject) throws MojoExecutionException {
        if (artifact.getClassifier() != null) {
            return artifact.getFile();
        }
        String refId = artifact.getGroupId() + ":" + artifact.getArtifactId();
        MavenProject project = (MavenProject)mavenProject.getProjectReferences().get(refId);
        if (project != null) {
            return new File(project.getBuild().getOutputDirectory());
        }
        File file = artifact.getFile();
        if (file == null || !file.exists()) {
            throw new MojoExecutionException("Dependency Resolution Required " + artifact);
        }
        return file;
    }
}

