/*
 * Decompiled with CFR 0.152.
 */
package com.p.indicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;

public class BezierCircular {
    private static final String TAG = "BezierCircular";
    private static final float C = 0.55191505f;
    float centerX;
    float centerY;
    float radius;
    private PointF currentPoint;
    private PointF targetPoint;
    private float mDifference;
    private float stretchDistance;
    private float cDistance;
    private float moveDistance;
    private float[] mData = new float[8];
    private float[] mCtrl = new float[16];

    public BezierCircular(float radius) {
        this.radius = radius;
        this.stretchDistance = radius / 3.0f * 2.0f;
        this.mDifference = radius * 0.55191505f;
        this.cDistance = this.mDifference * 0.45f;
    }

    public void setCenter(float centerX, float centerY) {
        this.centerX = centerX;
        this.centerY = centerY;
    }

    public void initControlPoint() {
        this.mData[0] = this.centerX;
        this.mData[1] = this.centerY + this.radius;
        this.mData[2] = this.centerX + this.radius;
        this.mData[3] = this.centerY;
        this.mData[4] = this.centerX;
        this.mData[5] = this.centerY - this.radius;
        this.mData[6] = this.centerX - this.radius;
        this.mData[7] = this.centerY;
        this.mCtrl[0] = this.mData[0] + this.mDifference;
        this.mCtrl[1] = this.mData[1];
        this.mCtrl[2] = this.mData[2];
        this.mCtrl[3] = this.mData[3] + this.mDifference;
        this.mCtrl[4] = this.mData[2];
        this.mCtrl[5] = this.mData[3] - this.mDifference;
        this.mCtrl[6] = this.mData[4] + this.mDifference;
        this.mCtrl[7] = this.mData[5];
        this.mCtrl[8] = this.mData[4] - this.mDifference;
        this.mCtrl[9] = this.mData[5];
        this.mCtrl[10] = this.mData[6];
        this.mCtrl[11] = this.mData[7] - this.mDifference;
        this.mCtrl[12] = this.mData[6];
        this.mCtrl[13] = this.mData[7] + this.mDifference;
        this.mCtrl[14] = this.mData[0] - this.mDifference;
        this.mCtrl[15] = this.mData[1];
    }

    public void setCurrentAndTarget(PointF currentPoint, PointF targetPoint) {
        this.currentPoint = currentPoint;
        this.targetPoint = targetPoint;
        float distance = targetPoint.x - currentPoint.x;
        this.moveDistance = distance > 0.0f ? distance - 2.0f * this.stretchDistance : distance + 2.0f * this.stretchDistance;
    }

    public void setProgress(float progress) {
        if (progress > 0.0f && (double)progress <= 0.2 || progress < 0.0f && (double)progress >= -0.2) {
            this.model1(progress);
        } else if ((double)progress > 0.2 && (double)progress <= 0.5 || (double)progress < -0.2 && (double)progress >= -0.5) {
            this.model2(progress);
        } else if ((double)progress > 0.5 && (double)progress <= 0.8 || (double)progress < -0.5 && (double)progress >= -0.8) {
            this.model3(progress);
        } else if ((double)progress > 0.8 && (double)progress <= 0.9 || (double)progress < -0.8 && (double)progress >= -0.9) {
            this.model4(progress);
        } else if ((double)progress > 0.9 && progress < 1.0f || (double)progress < -0.9 && progress > -1.0f) {
            this.model5(progress);
        }
    }

    public void model1(float progress) {
        if (progress > 0.0f) {
            this.mData[2] = this.centerX + this.radius + this.stretchDistance * progress * 5.0f;
        }
        if (progress < 0.0f) {
            this.mData[6] = this.centerX - this.radius + this.stretchDistance * progress * 5.0f;
        }
        this.mCtrl[2] = this.mData[2];
        if (progress > 0.0f) {
            this.mCtrl[3] = this.mData[3] + this.mDifference + this.cDistance * progress * 5.0f;
        }
        this.mCtrl[4] = this.mData[2];
        if (progress > 0.0f) {
            this.mCtrl[5] = this.mData[3] - this.mDifference - this.cDistance * progress * 5.0f;
        }
        this.mCtrl[10] = this.mData[6];
        if (progress < 0.0f) {
            this.mCtrl[11] = this.mData[7] - this.mDifference + this.cDistance * progress * 5.0f;
        }
        this.mCtrl[12] = this.mData[6];
        if (progress < 0.0f) {
            this.mCtrl[13] = this.mData[7] + this.mDifference - this.cDistance * progress * 5.0f;
        }
    }

    public void model2(float progress) {
        this.model1(progress > 0.0f ? 0.2f : -0.2f);
        progress = progress > 0.0f ? (progress - 0.2f) * 3.3333333f : (progress + 0.2f) * 3.3333333f;
        this.mData[0] = this.centerX + this.stretchDistance * progress;
        this.mData[2] = progress > 0.0f ? this.centerX + this.radius + this.stretchDistance * (1.0f + progress) : this.centerX + this.radius;
        this.mData[4] = this.centerX + this.stretchDistance * progress;
        this.mData[6] = progress < 0.0f ? this.centerX - this.radius - this.stretchDistance + this.stretchDistance * progress : this.centerX - this.radius;
        this.mCtrl[0] = this.mData[0] + this.mDifference;
        this.mCtrl[2] = this.mData[2];
        this.mCtrl[3] = progress > 0.0f ? this.mData[3] + this.mDifference + this.cDistance : this.mData[3] + this.mDifference - this.cDistance * progress;
        this.mCtrl[4] = this.mData[2];
        this.mCtrl[5] = progress > 0.0f ? this.mData[3] - this.mDifference - this.cDistance : this.mData[3] - this.mDifference + this.cDistance * progress;
        this.mCtrl[6] = this.mData[4] + this.mDifference;
        this.mCtrl[8] = this.mData[4] - this.mDifference;
        this.mCtrl[10] = this.mData[6];
        this.mCtrl[11] = progress > 0.0f ? this.mData[7] - this.mDifference - this.cDistance * progress : this.mData[7] - this.mDifference - this.cDistance;
        this.mCtrl[12] = this.mData[6];
        this.mCtrl[13] = progress > 0.0f ? this.mData[7] + this.mDifference + this.cDistance * progress : this.mData[7] + this.mDifference + this.cDistance;
        this.mCtrl[14] = this.mData[0] - this.mDifference;
    }

    public void model3(float progress) {
        this.model2(progress > 0.0f ? 0.5f : -0.5f);
        progress = progress > 0.0f ? (progress - 0.5f) * 3.3333333f : (progress + 0.5f) * 3.3333333f;
        this.mData[0] = progress > 0.0f ? this.centerX + this.moveDistance * progress + this.stretchDistance : this.centerX - this.moveDistance * progress - this.stretchDistance;
        this.mData[2] = progress > 0.0f ? this.centerX + this.moveDistance * progress + this.radius + 2.0f * this.stretchDistance : this.centerX - this.moveDistance * progress + this.radius;
        this.mData[4] = progress > 0.0f ? this.centerX + this.moveDistance * progress + this.stretchDistance : this.centerX - this.moveDistance * progress - this.stretchDistance;
        this.mData[6] = progress > 0.0f ? this.centerX + this.moveDistance * progress - this.radius : this.centerX - this.moveDistance * progress - this.radius - 2.0f * this.stretchDistance;
        this.mCtrl[0] = this.mData[0] + this.mDifference;
        this.mCtrl[2] = this.mData[2];
        this.mCtrl[3] = this.mData[3] + this.mDifference + this.cDistance;
        this.mCtrl[4] = this.mData[2];
        this.mCtrl[5] = this.mData[3] - this.mDifference - this.cDistance;
        this.mCtrl[6] = this.mData[4] + this.mDifference;
        this.mCtrl[8] = this.mData[4] - this.mDifference;
        this.mCtrl[10] = this.mData[6];
        this.mCtrl[11] = this.mData[7] - this.mDifference - this.cDistance;
        this.mCtrl[12] = this.mData[6];
        this.mCtrl[13] = this.mData[7] + this.mDifference + this.cDistance;
        this.mCtrl[14] = this.mData[0] - this.mDifference;
    }

    public void model4(float progress) {
        this.model3(progress > 0.0f ? 0.8f : -0.8f);
        progress = progress > 0.0f ? (progress - 0.8f) * 10.0f : (progress + 0.8f) * 10.0f;
        this.mData[0] = progress > 0.0f ? this.centerX + this.moveDistance + this.stretchDistance + this.stretchDistance * progress : this.centerX + this.moveDistance - this.stretchDistance + this.stretchDistance * progress;
        this.mData[2] = progress > 0.0f ? this.centerX + this.moveDistance + this.radius + 2.0f * this.stretchDistance : this.centerX + this.moveDistance + this.radius + this.stretchDistance * progress;
        this.mData[4] = progress > 0.0f ? this.centerX + this.moveDistance + this.stretchDistance + this.stretchDistance * progress : this.centerX + this.moveDistance - this.stretchDistance + this.stretchDistance * progress;
        this.mData[6] = progress > 0.0f ? this.centerX + this.moveDistance - this.radius + this.stretchDistance * progress : this.centerX + this.moveDistance - this.radius - 2.0f * this.stretchDistance;
        this.mCtrl[0] = this.mData[0] + this.mDifference;
        this.mCtrl[2] = this.mData[2];
        this.mCtrl[3] = progress > 0.0f ? this.mData[3] + this.mDifference + this.cDistance - this.cDistance * progress : this.mData[3] + this.mDifference + this.cDistance;
        this.mCtrl[4] = this.mData[2];
        this.mCtrl[5] = progress > 0.0f ? this.mData[3] - this.mDifference - this.cDistance + this.cDistance * progress : this.mData[3] - this.mDifference - this.cDistance;
        this.mCtrl[6] = this.mData[4] + this.mDifference;
        this.mCtrl[8] = this.mData[4] - this.mDifference;
        this.mCtrl[10] = this.mData[6];
        this.mCtrl[11] = progress > 0.0f ? this.mData[7] - this.mDifference - this.cDistance : this.mData[7] - this.mDifference - this.cDistance - this.cDistance * progress;
        this.mCtrl[12] = this.mData[6];
        this.mCtrl[13] = progress > 0.0f ? this.mData[7] + this.mDifference + this.cDistance : this.mData[7] + this.mDifference + this.cDistance + this.cDistance * progress;
        this.mCtrl[14] = this.mData[0] - this.mDifference;
    }

    public void model5(float progress) {
        this.model4(progress > 0.0f ? 0.9f : -0.9f);
        progress = progress > 0.0f ? (progress - 0.9f) * 10.0f : (progress + 0.9f) * 10.0f;
        this.mData[0] = progress > 0.0f ? this.centerX + this.moveDistance + 2.0f * this.stretchDistance : this.centerX + this.moveDistance - 2.0f * this.stretchDistance;
        this.mData[2] = progress > 0.0f ? this.centerX + this.moveDistance + this.radius + 2.0f * this.stretchDistance : (float)((double)(this.centerX + this.moveDistance + this.radius - this.stretchDistance) - (Math.sin(4.71238898038469 * (double)Math.abs(progress) - 1.5707963267948966) + 1.0) * (double)this.stretchDistance);
        this.mData[4] = progress > 0.0f ? this.centerX + this.moveDistance + 2.0f * this.stretchDistance : this.centerX + this.moveDistance - 2.0f * this.stretchDistance;
        this.mData[6] = progress > 0.0f ? (float)((double)(this.centerX + this.moveDistance - this.radius + this.stretchDistance) + (Math.sin(4.71238898038469 * (double)progress - 1.5707963267948966) + 1.0) * (double)this.stretchDistance) : this.centerX + this.moveDistance - this.radius - 2.0f * this.stretchDistance;
        this.mCtrl[0] = this.mData[0] + this.mDifference;
        this.mCtrl[2] = this.mData[2];
        if (progress < 0.0f) {
            this.mCtrl[3] = this.mData[3] + this.mDifference + this.cDistance + this.cDistance * progress;
        }
        this.mCtrl[4] = this.mData[2];
        if (progress < 0.0f) {
            this.mCtrl[5] = this.mData[3] - this.mDifference - this.cDistance - this.cDistance * progress;
        }
        this.mCtrl[6] = this.mData[4] + this.mDifference;
        this.mCtrl[8] = this.mData[4] - this.mDifference;
        this.mCtrl[10] = this.mData[6];
        if (progress > 0.0f) {
            this.mCtrl[11] = this.mData[7] - this.mDifference - this.cDistance + this.cDistance * progress;
        }
        this.mCtrl[12] = this.mData[6];
        if (progress > 0.0f) {
            this.mCtrl[13] = this.mData[7] + this.mDifference + this.cDistance - this.cDistance * progress;
        }
        this.mCtrl[14] = this.mData[0] - this.mDifference;
    }

    public void drawCircle(Canvas canvas, Paint mPaint) {
        Path path = new Path();
        path.moveTo(this.mData[0], this.mData[1]);
        path.cubicTo(this.mCtrl[0], this.mCtrl[1], this.mCtrl[2], this.mCtrl[3], this.mData[2], this.mData[3]);
        path.cubicTo(this.mCtrl[4], this.mCtrl[5], this.mCtrl[6], this.mCtrl[7], this.mData[4], this.mData[5]);
        path.cubicTo(this.mCtrl[8], this.mCtrl[9], this.mCtrl[10], this.mCtrl[11], this.mData[6], this.mData[7]);
        path.cubicTo(this.mCtrl[12], this.mCtrl[13], this.mCtrl[14], this.mCtrl[15], this.mData[0], this.mData[1]);
        canvas.drawPath(path, mPaint);
    }

    public void resetCircular(PointF pointF) {
        this.setCenter(pointF.x, pointF.y);
        this.initControlPoint();
    }
}

