/*
 * Decompiled with CFR 0.152.
 */
package com.github.wujun234.uid.worker;

import com.github.wujun234.uid.utils.DockerUtils;
import com.github.wujun234.uid.utils.NetUtils;
import com.github.wujun234.uid.worker.WorkerIdAssigner;
import com.github.wujun234.uid.worker.WorkerNodeType;
import com.github.wujun234.uid.worker.dao.WorkerNodeDAO;
import com.github.wujun234.uid.worker.entity.WorkerNodeEntity;
import javax.annotation.Resource;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class DisposableWorkerIdAssigner
implements WorkerIdAssigner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisposableWorkerIdAssigner.class);
    @Resource
    private WorkerNodeDAO workerNodeDAO;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long assignWorkerId() {
        WorkerNodeEntity workerNodeEntity = this.buildWorkerNode();
        WorkerNodeEntity oldWorkerNode = this.workerNodeDAO.getWorkerNodeByHostPort(workerNodeEntity.getHostName(), workerNodeEntity.getPort());
        if (null != oldWorkerNode) {
            return oldWorkerNode.getId();
        }
        this.workerNodeDAO.addWorkerNode(workerNodeEntity);
        LOGGER.info("Add worker node:" + workerNodeEntity);
        return workerNodeEntity.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long assignFakeWorkerId() {
        return this.buildFakeWorkerNode().getId();
    }

    private WorkerNodeEntity buildWorkerNode() {
        WorkerNodeEntity workerNodeEntity = new WorkerNodeEntity();
        if (DockerUtils.isDocker()) {
            workerNodeEntity.setType(WorkerNodeType.CONTAINER.value());
            workerNodeEntity.setHostName(DockerUtils.getDockerHost());
            workerNodeEntity.setPort(DockerUtils.getDockerPort());
        } else {
            workerNodeEntity.setType(WorkerNodeType.ACTUAL.value());
            workerNodeEntity.setHostName(NetUtils.getLocalAddress());
            workerNodeEntity.setPort(System.currentTimeMillis() + "-" + RandomUtils.nextInt((int)100000));
        }
        return workerNodeEntity;
    }

    private WorkerNodeEntity buildFakeWorkerNode() {
        WorkerNodeEntity workerNodeEntity = new WorkerNodeEntity();
        workerNodeEntity.setType(WorkerNodeType.FAKE.value());
        if (DockerUtils.isDocker()) {
            workerNodeEntity.setHostName(DockerUtils.getDockerHost());
            workerNodeEntity.setPort(DockerUtils.getDockerPort() + "-" + RandomUtils.nextInt((int)100000));
        } else {
            workerNodeEntity.setHostName(NetUtils.getLocalAddress());
            workerNodeEntity.setPort(System.currentTimeMillis() + "-" + RandomUtils.nextInt((int)100000));
        }
        return workerNodeEntity;
    }
}

