/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.stream;

import android.support.v4.util.ArrayMap;
import android.support.v4.util.ArraySet;
import android.support.v4.util.LongSparseArray;
import android.util.SparseArray;
import com.github.wrdlbrnft.streamcompat.compat.LongSparseArrayCompat;
import com.github.wrdlbrnft.streamcompat.compat.MapCompat;
import com.github.wrdlbrnft.streamcompat.compat.SparseArrayCompat;
import com.github.wrdlbrnft.streamcompat.function.BiConsumer;
import com.github.wrdlbrnft.streamcompat.function.BinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.function.IntFunction;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.function.ToIntFunction;
import com.github.wrdlbrnft.streamcompat.function.ToLongFunction;
import com.github.wrdlbrnft.streamcompat.stream.Collector;
import com.github.wrdlbrnft.streamcompat.stream.CollectorImpl;
import com.github.wrdlbrnft.streamcompat.util.StringJoiner;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Collectors {
    public static <T> Collector<T, ?, T[]> toArray(IntFunction<T[]> arrayGenerator) {
        return new CollectorImpl<Object, List, Object[]>(ArrayList::new, List::add, list -> {
            Object[] array = (Object[])arrayGenerator.apply(list.size());
            return list.toArray(array);
        });
    }

    public static <T> Collector<T, ?, List<T>> toList() {
        return Collectors.toList(ArrayList::new);
    }

    public static <T, L extends List<T>> Collector<T, ?, L> toList(Supplier<L> listSupplier) {
        return new CollectorImpl<Object, List, List>(listSupplier, List::add, i -> i);
    }

    public static <T> Collector<T, ?, List<T>> toOrderedList(Comparator<T> comparator) {
        return Collectors.toOrderedList(ArrayList::new, comparator);
    }

    public static <T, L extends List<T>> Collector<T, ?, L> toOrderedList(Supplier<L> listSupplier, Comparator<T> comparator) {
        return new CollectorImpl<Object, List, List>(listSupplier, List::add, list -> {
            Collections.sort(list, comparator);
            return list;
        });
    }

    public static <T extends Comparable<T>> Collector<T, ?, List<T>> toOrderedList() {
        return Collectors.toOrderedList(ArrayList::new);
    }

    public static <T extends Comparable<T>, L extends List<T>> Collector<T, ?, L> toOrderedList(Supplier<L> listSupplier) {
        return new CollectorImpl<Comparable, List, List>(listSupplier, List::add, list -> {
            Collections.sort(list);
            return list;
        });
    }

    public static <T> Collector<T, ?, Set<T>> toSet() {
        return Collectors.toSet(ArraySet::new);
    }

    public static <T, S extends Set<T>> Collector<T, ?, S> toSet(Supplier<S> setSupplier) {
        return new CollectorImpl<Object, Set, Set>(setSupplier, Set::add, i -> i);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        BiConsumer<Map, Object> accumulator = (map, element) -> {
            Object key = keyMapper.apply(element);
            Object value = map.containsKey(key) ? mergeFunction.apply(map.get(key), valueMapper.apply(element)) : valueMapper.apply(element);
            map.put(key, value);
        };
        return new CollectorImpl<Object, Map, Map>(mapSupplier, accumulator, i -> i);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Supplier<M> mapSupplier) {
        return Collectors.toMap(keyMapper, valueMapper, Collectors.throwingMerger(), mapSupplier);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return Collectors.toMap(keyMapper, valueMapper, mergeFunction, ArrayMap::new);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, Collectors.throwingMerger(), ArrayMap::new);
    }

    public static <T, U> Collector<T, ?, SparseArray<U>> toSparseArray(ToIntFunction<? super T> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        BiConsumer<SparseArray, Object> accumulator = (map, element) -> {
            int key = keyMapper.apply(element);
            Object current = map.get(key);
            Object value = current != null ? mergeFunction.apply(current, valueMapper.apply(element)) : valueMapper.apply(element);
            map.put(key, value);
        };
        return new CollectorImpl<Object, SparseArray, SparseArray>(SparseArray::new, accumulator, i -> i);
    }

    public static <T, U> Collector<T, ?, SparseArray<U>> toSparseArray(ToIntFunction<? super T> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toSparseArray(keyMapper, valueMapper, Collectors.throwingMerger());
    }

    public static <T, U> Collector<T, ?, LongSparseArray<U>> toLongSparseArray(ToLongFunction<? super T> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        BiConsumer<LongSparseArray, Object> accumulator = (map, element) -> {
            long key = keyMapper.apply(element);
            Object current = map.get(key);
            Object value = current != null ? mergeFunction.apply(current, valueMapper.apply(element)) : valueMapper.apply(element);
            map.put(key, value);
        };
        return new CollectorImpl<Object, LongSparseArray, LongSparseArray>(LongSparseArray::new, accumulator, i -> i);
    }

    public static <T, U> Collector<T, ?, LongSparseArray<U>> toLongSparseArray(ToLongFunction<? super T> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toLongSparseArray(keyMapper, valueMapper, Collectors.throwingMerger());
    }

    private static <U> BinaryOperator<U> throwingMerger() {
        return (t, u) -> {
            throw new IllegalStateException("Multiple values mapped to the same key");
        };
    }

    public static <T, K, D, A, M extends Map<K, D>> Collector<T, ?, M> groupingBy(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BiConsumer<Map, Object> accumulator = (m, t) -> {
            Object key = Utils.requireNonNull(classifier.apply(t), "element cannot be mapped to a null key");
            Object container = MapCompat.computeIfAbsent(m, key, k -> downstreamSupplier.get());
            downstreamAccumulator.accept(container, t);
        };
        Supplier<M> mangledFactory = mapFactory;
        Function downstreamFinisher = downstream.finisher();
        Function<Map, Map> finisher = intermediate -> {
            MapCompat.replaceAll(intermediate, (k, v) -> downstreamFinisher.apply(v));
            return intermediate;
        };
        return new CollectorImpl<Object, Map, Map>(mangledFactory, accumulator, finisher);
    }

    public static <T, K, A, D> Collector<T, ?, Map<K, D>> groupingBy(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return Collectors.groupingBy(classifier, ArrayMap::new, downstream);
    }

    public static <T, K> Collector<T, ?, Map<K, List<T>>> groupingBy(Function<? super T, ? extends K> classifier) {
        return Collectors.groupingBy(classifier, Collectors.toList());
    }

    public static <T, A, D> Collector<T, ?, SparseArray<D>> groupInSparseArray(ToIntFunction<? super T> classifier, Collector<? super T, A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BiConsumer<SparseArray, Object> accumulator = (m, t) -> {
            int key = classifier.apply(t);
            Object container = SparseArrayCompat.computeIfAbsent(m, key, k -> downstreamSupplier.get());
            downstreamAccumulator.accept(container, t);
        };
        Function downstreamFinisher = downstream.finisher();
        Function<SparseArray, SparseArray> finisher = intermediate -> {
            SparseArrayCompat.replaceAll(intermediate, (k, v) -> downstreamFinisher.apply(v));
            return intermediate;
        };
        return new CollectorImpl<Object, SparseArray, SparseArray>(SparseArray::new, accumulator, finisher);
    }

    public static <T> Collector<T, ?, SparseArray<List<T>>> groupInSparseArray(ToIntFunction<? super T> classifier) {
        return Collectors.groupInSparseArray(classifier, Collectors.toList());
    }

    public static <T, A, D> Collector<T, ?, LongSparseArray<D>> groupInLongSparseArray(ToLongFunction<? super T> classifier, Collector<? super T, A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BiConsumer<LongSparseArray, Object> accumulator = (m, t) -> {
            long key = classifier.apply(t);
            Object container = LongSparseArrayCompat.computeIfAbsent(m, key, k -> downstreamSupplier.get());
            downstreamAccumulator.accept(container, t);
        };
        Function downstreamFinisher = downstream.finisher();
        Function<LongSparseArray, LongSparseArray> finisher = intermediate -> {
            LongSparseArrayCompat.replaceAll(intermediate, (k, v) -> downstreamFinisher.apply(v));
            return intermediate;
        };
        return new CollectorImpl<Object, LongSparseArray, LongSparseArray>(LongSparseArray::new, accumulator, finisher);
    }

    public static <T> Collector<T, ?, LongSparseArray<List<T>>> groupInLongSparseArray(ToLongFunction<? super T> classifier) {
        return Collectors.groupInLongSparseArray(classifier, Collectors.toList());
    }

    public static <T, A, R> Collector<T, A, R> create(Supplier<A> supplier, BiConsumer<A, T> accumulator, Function<A, R> finisher) {
        return new CollectorImpl<T, A, R>(supplier, accumulator, finisher);
    }

    public static <T> Collector<T, ?, String> joining() {
        return new CollectorImpl<Object, StringBuilder, String>(StringBuilder::new, StringBuilder::append, StringBuilder::toString);
    }

    public static <T> Collector<T, ?, String> joining(String delimiter) {
        return new CollectorImpl<Object, StringJoiner, String>(() -> new StringJoiner(delimiter, "", ""), StringJoiner::add, StringJoiner::toString);
    }

    public static <T> Collector<T, ?, String> joining(String delimiter, String prefix, String suffix) {
        return new CollectorImpl<Object, StringJoiner, String>(() -> new StringJoiner(delimiter, prefix, suffix), StringJoiner::add, StringJoiner::toString);
    }
}

