/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.intstream;

import android.support.annotation.NonNull;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteStream;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteStreamCompat;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStream;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamCompat;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamCompat;
import com.github.wrdlbrnft.streamcompat.function.Consumer;
import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.function.IntBinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.IntConsumer;
import com.github.wrdlbrnft.streamcompat.function.IntFunction;
import com.github.wrdlbrnft.streamcompat.function.IntPredicate;
import com.github.wrdlbrnft.streamcompat.function.IntToByteFunction;
import com.github.wrdlbrnft.streamcompat.function.IntToCharFunction;
import com.github.wrdlbrnft.streamcompat.function.IntToDoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.IntToFloatFunction;
import com.github.wrdlbrnft.streamcompat.function.IntToLongFunction;
import com.github.wrdlbrnft.streamcompat.function.IntUnaryOperator;
import com.github.wrdlbrnft.streamcompat.function.ObjIntConsumer;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.function.ToIntFunction;
import com.github.wrdlbrnft.streamcompat.intstream.IntExceptional;
import com.github.wrdlbrnft.streamcompat.intstream.IntIteratorWrapper;
import com.github.wrdlbrnft.streamcompat.intstream.IntIteratorWrapperImpl;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat;
import com.github.wrdlbrnft.streamcompat.iterator.array.IntArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ByteChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.CharChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.DoubleChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.FloatChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.IntChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.LongChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.IntIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat;
import com.github.wrdlbrnft.streamcompat.optionals.OptionalDouble;
import com.github.wrdlbrnft.streamcompat.optionals.OptionalInt;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.Arrays;
import java.util.Iterator;

class IntStreamImpl
implements IntStream {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private final IntIteratorWrapper mIteratorWrapper = new IntIteratorWrapperImpl();
    private final IntIterator mIterator;

    IntStreamImpl(IntIterator iterator) {
        this.mIterator = this.mIteratorWrapper.apply(iterator);
    }

    @Override
    public IntStream filter(IntPredicate predicate) {
        Utils.requireNonNull(predicate);
        DummyIterator iterator = new DummyIterator();
        return new IntStreamImpl(new IntChildIterator(() -> {
            while (this.mIterator.hasNext()) {
                int value = this.mIterator.nextInt();
                if (!predicate.test(value)) continue;
                return iterator.newValue(value);
            }
            return iterator;
        }, Iterator::hasNext, IntIterator::nextInt));
    }

    @Override
    public IntStream map(IntUnaryOperator mapper) {
        Utils.requireNonNull(mapper);
        return new IntStreamImpl(new IntChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsInt(this.mIterator.nextInt())));
    }

    @Override
    public IntStream flatMap(IntFunction<? extends IntStream> mapper) {
        Utils.requireNonNull(mapper);
        IntIterator[] buffer = new IntIterator[1];
        return new IntStreamImpl(new IntChildIterator(() -> {
            if (buffer[0] == null || !buffer[0].hasNext()) {
                if (!this.mIterator.hasNext()) {
                    return IntStreamCompat.EMPTY_ITERATOR;
                }
                buffer[0] = ((IntStream)mapper.apply(this.mIterator.nextInt())).iterator();
            }
            return buffer[0];
        }, Iterator::hasNext, IntIterator::nextInt));
    }

    @Override
    public <U> Stream<U> mapToObj(IntFunction<? extends U> mapper) {
        Utils.requireNonNull(mapper);
        return StreamCompat.of(new ChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.apply(this.mIterator.nextInt())));
    }

    @Override
    public LongStream mapToLong(IntToLongFunction mapper) {
        Utils.requireNonNull(mapper);
        return LongStreamCompat.of(new LongChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsLong(this.mIterator.nextInt())));
    }

    @Override
    public DoubleStream mapToDouble(IntToDoubleFunction mapper) {
        Utils.requireNonNull(mapper);
        return DoubleStreamCompat.of(new DoubleChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsDouble(this.mIterator.nextInt())));
    }

    @Override
    public FloatStream mapToFloat(IntToFloatFunction mapper) {
        Utils.requireNonNull(mapper);
        return FloatStreamCompat.of(new FloatChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsFloat(this.mIterator.nextInt())));
    }

    @Override
    public CharacterStream mapToChar(IntToCharFunction mapper) {
        Utils.requireNonNull(mapper);
        return CharacterStreamCompat.of(new CharChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsChar(this.mIterator.nextInt())));
    }

    @Override
    public ByteStream mapToByte(IntToByteFunction mapper) {
        Utils.requireNonNull(mapper);
        return ByteStreamCompat.of(new ByteChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsByte(this.mIterator.nextInt())));
    }

    @Override
    @NonNull
    public IntIterator iterator() {
        return this.mIterator;
    }

    @Override
    public void forEach(IntConsumer action) {
        Utils.requireNonNull(action);
        while (this.mIterator.hasNext()) {
            int i = this.mIterator.nextInt();
            action.accept(i);
        }
    }

    @Override
    public Stream<Integer> boxed() {
        return this.mapToObj(Integer::valueOf);
    }

    @Override
    public IntStream limit(long limit) {
        long[] buffer = new long[]{0L, limit};
        return new IntStreamImpl(new IntChildIterator(() -> this.mIterator, iterator -> buffer[0] < buffer[1] && this.mIterator.hasNext(), iterator -> {
            buffer[0] = buffer[0] + 1L;
            return iterator.nextInt();
        }));
    }

    @Override
    public IntStream skip(long count) {
        long[] buffer = new long[]{0L, count};
        return new IntStreamImpl(new IntChildIterator(() -> {
            while (this.mIterator.hasNext() && buffer[0] < buffer[1]) {
                this.mIterator.nextInt();
                buffer[0] = buffer[0] + 1L;
            }
            return this.mIterator;
        }, Iterator::hasNext, IntIterator::nextInt));
    }

    @Override
    public int reduce(int identity, IntBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        int current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsInt(current, this.mIterator.nextInt());
        }
        return current;
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        if (!this.mIterator.hasNext()) {
            return OptionalInt.empty();
        }
        int current = this.mIterator.nextInt();
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsInt(current, this.mIterator.nextInt());
        }
        return OptionalInt.of(current);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator) {
        Utils.requireNonNull(supplier);
        Utils.requireNonNull(accumulator);
        R sink = supplier.get();
        while (this.mIterator.hasNext()) {
            accumulator.accept(sink, this.mIterator.nextInt());
        }
        return sink;
    }

    @Override
    public <E extends Throwable> IntExceptional<E> exception(Class<E> cls) {
        return new IntExceptionalImpl<E>(cls);
    }

    @Override
    public int sum() {
        return this.reduce(0, (a, b) -> a + b);
    }

    @Override
    public OptionalInt min() {
        return this.reduce(Math::min);
    }

    @Override
    public OptionalInt max() {
        return this.reduce(Math::max);
    }

    @Override
    public long count() {
        return this.mapToLong(i -> 1L).sum();
    }

    @Override
    public IntStream sort() {
        return new IntStreamImpl(new IntChildIterator(() -> {
            int[] array = this.toArray();
            Arrays.sort(array);
            return new IntArrayIterator(array);
        }, Iterator::hasNext, IntIterator::nextInt));
    }

    @Override
    public OptionalDouble average() {
        long[] avg = this.collect(() -> new long[2], (ll, i) -> {
            ll[0] = ll[0] + 1L;
            ll[1] = ll[1] + (long)i;
        });
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public OptionalInt findFirst() {
        return this.mIterator.hasNext() ? OptionalInt.of(this.mIterator.nextInt()) : OptionalInt.empty();
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextInt())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.nextInt())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextInt())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] toArray() {
        int[] tmp = new int[16];
        int index = 0;
        while (this.mIterator.hasNext()) {
            int c = this.mIterator.nextInt();
            if (index >= tmp.length) {
                int[] newArray = new int[tmp.length * 2];
                System.arraycopy(tmp, 0, newArray, 0, tmp.length);
                tmp = newArray;
            }
            tmp[index++] = c;
        }
        int[] result = new int[index];
        System.arraycopy(tmp, 0, result, 0, index);
        return result;
    }

    private class IntExceptionalImpl<E extends Throwable>
    implements IntExceptional<E> {
        private final Class<E> mExceptionClass;

        public IntExceptionalImpl(Class<E> exceptionClass) {
            this.mExceptionClass = exceptionClass;
        }

        @Override
        public IntStream mapException(ToIntFunction<E> mapper) {
            IntStreamImpl.this.mIteratorWrapper.mapException(this.mExceptionClass, mapper);
            return IntStreamImpl.this;
        }

        @Override
        public IntStream consume(Consumer<E> consumer) {
            IntStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, consumer);
            return IntStreamImpl.this;
        }

        @Override
        public <I extends RuntimeException> IntStream rethrow(Function<E, I> mapper) {
            IntStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, e -> {
                throw (RuntimeException)mapper.apply(e);
            });
            return IntStreamImpl.this;
        }

        @Override
        public IntStream ignore() {
            IntStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, e -> {});
            return IntStreamImpl.this;
        }
    }

    private static class DummyIterator
    extends BaseIterator<Integer>
    implements IntIterator {
        private int mValue;
        private boolean mHasNext;

        public DummyIterator(int value) {
            this(value, true);
        }

        public DummyIterator() {
            this(0, false);
        }

        private DummyIterator(int value, boolean hasNext) {
            this.mValue = value;
            this.mHasNext = hasNext;
        }

        public DummyIterator newValue(int value) {
            this.mValue = value;
            this.mHasNext = true;
            return this;
        }

        @Override
        public int nextInt() {
            this.mHasNext = false;
            return this.mValue;
        }

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }
    }
}

