/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.floatstream;

import android.support.annotation.NonNull;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteStream;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteStreamCompat;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStream;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamCompat;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatExceptional;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatIteratorWrapper;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatIteratorWrapperImpl;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamCompat;
import com.github.wrdlbrnft.streamcompat.function.Consumer;
import com.github.wrdlbrnft.streamcompat.function.FloatBinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.FloatConsumer;
import com.github.wrdlbrnft.streamcompat.function.FloatFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatPredicate;
import com.github.wrdlbrnft.streamcompat.function.FloatToByteFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatToCharFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatToDoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatToIntFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatToLongFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatUnaryOperator;
import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.function.ObjFloatConsumer;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.function.ToFloatFunction;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat;
import com.github.wrdlbrnft.streamcompat.iterator.array.FloatArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ByteChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.CharChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.DoubleChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.FloatChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.IntChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.LongChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.FloatIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat;
import com.github.wrdlbrnft.streamcompat.optionals.OptionalFloat;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat;
import com.github.wrdlbrnft.streamcompat.util.KahanSummation;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.Arrays;
import java.util.Iterator;

class FloatStreamImpl
implements FloatStream {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private final FloatIteratorWrapper mIteratorWrapper = new FloatIteratorWrapperImpl();
    private final FloatIterator mIterator;

    FloatStreamImpl(FloatIterator iterator) {
        this.mIterator = this.mIteratorWrapper.apply(iterator);
    }

    @Override
    public FloatStream filter(FloatPredicate predicate) {
        Utils.requireNonNull(predicate);
        DummyIterator iterator = new DummyIterator();
        return new FloatStreamImpl(new FloatChildIterator(() -> {
            while (this.mIterator.hasNext()) {
                float value = this.mIterator.nextFloat();
                if (!predicate.test(value)) continue;
                return iterator.newValue(value);
            }
            return iterator;
        }, Iterator::hasNext, FloatIterator::nextFloat));
    }

    @Override
    public FloatStream map(FloatUnaryOperator mapper) {
        Utils.requireNonNull(mapper);
        return new FloatStreamImpl(new FloatChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsFloat(this.mIterator.nextFloat())));
    }

    @Override
    public FloatStream flatMap(FloatFunction<? extends FloatStream> mapper) {
        Utils.requireNonNull(mapper);
        FloatIterator[] buffer = new FloatIterator[1];
        return new FloatStreamImpl(new FloatChildIterator(() -> {
            if (buffer[0] == null || !buffer[0].hasNext()) {
                if (!this.mIterator.hasNext()) {
                    return FloatStreamCompat.EMPTY_ITERATOR;
                }
                buffer[0] = ((FloatStream)mapper.apply(this.mIterator.nextFloat())).iterator();
            }
            return buffer[0];
        }, Iterator::hasNext, FloatIterator::nextFloat));
    }

    @Override
    public <U> Stream<U> mapToObj(FloatFunction<? extends U> mapper) {
        Utils.requireNonNull(mapper);
        return StreamCompat.of(new ChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.apply(this.mIterator.nextFloat())));
    }

    @Override
    public LongStream mapToLong(FloatToLongFunction mapper) {
        Utils.requireNonNull(mapper);
        return LongStreamCompat.of(new LongChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsLong(this.mIterator.nextFloat())));
    }

    @Override
    public IntStream mapToInt(FloatToIntFunction mapper) {
        Utils.requireNonNull(mapper);
        return IntStreamCompat.of(new IntChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsInt(this.mIterator.nextFloat())));
    }

    @Override
    public CharacterStream mapToChar(FloatToCharFunction mapper) {
        Utils.requireNonNull(mapper);
        return CharacterStreamCompat.of(new CharChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsChar(this.mIterator.nextFloat())));
    }

    @Override
    public DoubleStream mapToDouble(FloatToDoubleFunction mapper) {
        Utils.requireNonNull(mapper);
        return DoubleStreamCompat.of(new DoubleChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsDouble(this.mIterator.nextFloat())));
    }

    @Override
    public ByteStream mapToByte(FloatToByteFunction mapper) {
        Utils.requireNonNull(mapper);
        return ByteStreamCompat.of(new ByteChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsByte(this.mIterator.nextFloat())));
    }

    @Override
    @NonNull
    public FloatIterator iterator() {
        return this.mIterator;
    }

    @Override
    public void forEach(FloatConsumer action) {
        Utils.requireNonNull(action);
        while (this.mIterator.hasNext()) {
            float value = this.mIterator.nextFloat();
            action.accept(value);
        }
    }

    @Override
    public Stream<Float> boxed() {
        return this.mapToObj(Float::valueOf);
    }

    @Override
    public FloatStream limit(long limit) {
        long[] buffer = new long[]{0L, limit};
        return new FloatStreamImpl(new FloatChildIterator(() -> this.mIterator, iterator -> buffer[0] < buffer[1] && this.mIterator.hasNext(), iterator -> {
            buffer[0] = buffer[0] + 1L;
            return this.mIterator.nextFloat();
        }));
    }

    @Override
    public FloatStream skip(long count) {
        long[] buffer = new long[]{0L, count};
        return new FloatStreamImpl(new FloatChildIterator(() -> {
            while (this.mIterator.hasNext() && buffer[0] < buffer[1]) {
                this.mIterator.nextFloat();
                buffer[0] = buffer[0] + 1L;
            }
            return this.mIterator;
        }, Iterator::hasNext, FloatIterator::nextFloat));
    }

    @Override
    public float reduce(float identity, FloatBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        float current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsFloat(current, this.mIterator.nextFloat());
        }
        return current;
    }

    @Override
    public OptionalFloat reduce(FloatBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        if (!this.mIterator.hasNext()) {
            return OptionalFloat.empty();
        }
        float current = this.mIterator.nextFloat();
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsFloat(current, this.mIterator.nextFloat());
        }
        return OptionalFloat.of(current);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjFloatConsumer<R> accumulator) {
        Utils.requireNonNull(supplier);
        Utils.requireNonNull(accumulator);
        R sink = supplier.get();
        while (this.mIterator.hasNext()) {
            accumulator.accept(sink, this.mIterator.nextFloat());
        }
        return sink;
    }

    @Override
    public <E extends Throwable> FloatExceptional<E> exception(Class<E> cls) {
        return new FloatExceptionalImpl<E>(cls);
    }

    @Override
    public float sum() {
        float[] summation = this.collect(() -> new float[3], (ll, d) -> {
            KahanSummation.sumWithCompensation(ll, d);
            ll[2] = ll[2] + d;
        });
        return KahanSummation.computeFinalSum(summation);
    }

    @Override
    public OptionalFloat min() {
        return this.reduce(Math::min);
    }

    @Override
    public OptionalFloat max() {
        return this.reduce(Math::max);
    }

    @Override
    public long count() {
        return this.mapToLong(i -> 1L).sum();
    }

    @Override
    public FloatStream sort() {
        return new FloatStreamImpl(new FloatChildIterator(() -> {
            float[] array = this.toArray();
            Arrays.sort(array);
            return new FloatArrayIterator(array);
        }, Iterator::hasNext, FloatIterator::nextFloat));
    }

    @Override
    public OptionalFloat average() {
        float[] avg = this.collect(() -> new float[4], (ll, d) -> {
            ll[2] = ll[2] + 1.0f;
            KahanSummation.sumWithCompensation(ll, d);
            ll[3] = ll[3] + d;
        });
        return avg[2] > 0.0f ? OptionalFloat.of(KahanSummation.computeFinalSum(avg) / avg[2]) : OptionalFloat.empty();
    }

    @Override
    public OptionalFloat findFirst() {
        return this.mIterator.hasNext() ? OptionalFloat.of(this.mIterator.nextFloat()) : OptionalFloat.empty();
    }

    @Override
    public boolean anyMatch(FloatPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextFloat())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(FloatPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.nextFloat())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(FloatPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextFloat())) continue;
            return false;
        }
        return true;
    }

    @Override
    public float[] toArray() {
        float[] tmp = new float[16];
        int index = 0;
        while (this.mIterator.hasNext()) {
            float c = this.mIterator.nextFloat();
            if (index >= tmp.length) {
                float[] newArray = new float[tmp.length * 2];
                System.arraycopy(tmp, 0, newArray, 0, tmp.length);
                tmp = newArray;
            }
            tmp[index++] = c;
        }
        float[] result = new float[index];
        System.arraycopy(tmp, 0, result, 0, index);
        return result;
    }

    private class FloatExceptionalImpl<E extends Throwable>
    implements FloatExceptional<E> {
        private final Class<E> mExceptionClass;

        public FloatExceptionalImpl(Class<E> exceptionClass) {
            this.mExceptionClass = exceptionClass;
        }

        @Override
        public FloatStream mapException(ToFloatFunction<E> mapper) {
            FloatStreamImpl.this.mIteratorWrapper.mapException(this.mExceptionClass, mapper);
            return FloatStreamImpl.this;
        }

        @Override
        public FloatStream consume(Consumer<E> consumer) {
            FloatStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, consumer);
            return FloatStreamImpl.this;
        }

        @Override
        public <I extends RuntimeException> FloatStream rethrow(Function<E, I> mapper) {
            FloatStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, e -> {
                throw (RuntimeException)mapper.apply(e);
            });
            return FloatStreamImpl.this;
        }

        @Override
        public FloatStream ignore() {
            FloatStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, e -> {});
            return FloatStreamImpl.this;
        }
    }

    private static class DummyIterator
    extends BaseIterator<Float>
    implements FloatIterator {
        private float mValue;
        private boolean mHasNext;

        public DummyIterator(float value) {
            this(value, true);
        }

        public DummyIterator() {
            this(0.0f, false);
        }

        private DummyIterator(float value, boolean hasNext) {
            this.mValue = value;
            this.mHasNext = hasNext;
        }

        public DummyIterator newValue(float value) {
            this.mValue = value;
            this.mHasNext = true;
            return this;
        }

        @Override
        public float nextFloat() {
            this.mHasNext = false;
            return this.mValue;
        }

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public Float next() {
            return Float.valueOf(this.nextFloat());
        }
    }
}

