/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.doublestream;

import android.support.annotation.NonNull;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteStream;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteStreamCompat;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStream;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamCompat;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleExceptional;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleIteratorWrapper;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleIteratorWrapperImpl;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamCompat;
import com.github.wrdlbrnft.streamcompat.function.Consumer;
import com.github.wrdlbrnft.streamcompat.function.DoubleBinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.DoubleConsumer;
import com.github.wrdlbrnft.streamcompat.function.DoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.DoublePredicate;
import com.github.wrdlbrnft.streamcompat.function.DoubleToByteFunction;
import com.github.wrdlbrnft.streamcompat.function.DoubleToCharFunction;
import com.github.wrdlbrnft.streamcompat.function.DoubleToFloatFunction;
import com.github.wrdlbrnft.streamcompat.function.DoubleToIntFunction;
import com.github.wrdlbrnft.streamcompat.function.DoubleToLongFunction;
import com.github.wrdlbrnft.streamcompat.function.DoubleUnaryOperator;
import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.function.ObjDoubleConsumer;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.function.ToDoubleFunction;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat;
import com.github.wrdlbrnft.streamcompat.iterator.array.DoubleArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ByteChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.CharChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.DoubleChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.FloatChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.IntChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.LongChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.DoubleIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat;
import com.github.wrdlbrnft.streamcompat.optionals.OptionalDouble;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat;
import com.github.wrdlbrnft.streamcompat.util.KahanSummation;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.Arrays;
import java.util.Iterator;

class DoubleStreamImpl
implements DoubleStream {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private final DoubleIteratorWrapper mIteratorWrapper = new DoubleIteratorWrapperImpl();
    private final DoubleIterator mIterator;

    DoubleStreamImpl(DoubleIterator iterator) {
        this.mIterator = this.mIteratorWrapper.apply(iterator);
    }

    @Override
    public DoubleStream filter(DoublePredicate predicate) {
        Utils.requireNonNull(predicate);
        DummyIterator iterator = new DummyIterator();
        return new DoubleStreamImpl(new DoubleChildIterator(() -> {
            while (this.mIterator.hasNext()) {
                double value = this.mIterator.nextDouble();
                if (!predicate.test(value)) continue;
                return iterator.newValue(value);
            }
            return iterator;
        }, Iterator::hasNext, DoubleIterator::nextDouble));
    }

    @Override
    public DoubleStream map(DoubleUnaryOperator mapper) {
        Utils.requireNonNull(mapper);
        return new DoubleStreamImpl(new DoubleChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsDouble(iterator.nextDouble())));
    }

    @Override
    public DoubleStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        Utils.requireNonNull(mapper);
        DoubleIterator[] buffer = new DoubleIterator[1];
        return new DoubleStreamImpl(new DoubleChildIterator(() -> {
            if (buffer[0] == null || !buffer[0].hasNext()) {
                if (!this.mIterator.hasNext()) {
                    return DoubleStreamCompat.EMPTY_ITERATOR;
                }
                buffer[0] = ((DoubleStream)mapper.apply(this.mIterator.nextDouble())).iterator();
            }
            return buffer[0];
        }, Iterator::hasNext, DoubleIterator::nextDouble));
    }

    @Override
    public <U> Stream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        Utils.requireNonNull(mapper);
        return StreamCompat.of(new ChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.apply(this.mIterator.nextDouble())));
    }

    @Override
    public LongStream mapToLong(DoubleToLongFunction mapper) {
        Utils.requireNonNull(mapper);
        return LongStreamCompat.of(new LongChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsLong(this.mIterator.nextDouble())));
    }

    @Override
    public FloatStream mapToFloat(DoubleToFloatFunction mapper) {
        Utils.requireNonNull(mapper);
        return FloatStreamCompat.of(new FloatChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsFloat(this.mIterator.nextDouble())));
    }

    @Override
    public IntStream mapToInt(DoubleToIntFunction mapper) {
        Utils.requireNonNull(mapper);
        return IntStreamCompat.of(new IntChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsInt(this.mIterator.nextDouble())));
    }

    @Override
    public CharacterStream mapToChar(DoubleToCharFunction mapper) {
        Utils.requireNonNull(mapper);
        return CharacterStreamCompat.of(new CharChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsChar(this.mIterator.nextDouble())));
    }

    @Override
    public ByteStream mapToByte(DoubleToByteFunction mapper) {
        Utils.requireNonNull(mapper);
        return ByteStreamCompat.of(new ByteChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsByte(this.mIterator.nextDouble())));
    }

    @Override
    @NonNull
    public DoubleIterator iterator() {
        return this.mIterator;
    }

    @Override
    public void forEach(DoubleConsumer action) {
        Utils.requireNonNull(action);
        while (this.mIterator.hasNext()) {
            double value = this.mIterator.nextDouble();
            action.accept(value);
        }
    }

    @Override
    public Stream<Double> boxed() {
        return this.mapToObj(Double::valueOf);
    }

    @Override
    public DoubleStream limit(long limit) {
        long[] buffer = new long[]{0L, limit};
        return new DoubleStreamImpl(new DoubleChildIterator(() -> this.mIterator, iterator -> buffer[0] < buffer[1] && this.mIterator.hasNext(), iterator -> {
            buffer[0] = buffer[0] + 1L;
            return this.mIterator.nextDouble();
        }));
    }

    @Override
    public DoubleStream skip(long count) {
        long[] buffer = new long[]{0L, count};
        return new DoubleStreamImpl(new DoubleChildIterator(() -> {
            while (this.mIterator.hasNext() && buffer[0] < buffer[1]) {
                this.mIterator.nextDouble();
                buffer[0] = buffer[0] + 1L;
            }
            return this.mIterator;
        }, Iterator::hasNext, DoubleIterator::nextDouble));
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        double current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsDouble(current, this.mIterator.nextDouble());
        }
        return current;
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        if (!this.mIterator.hasNext()) {
            return OptionalDouble.empty();
        }
        double current = this.mIterator.nextDouble();
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsDouble(current, this.mIterator.nextDouble());
        }
        return OptionalDouble.of(current);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator) {
        Utils.requireNonNull(supplier);
        Utils.requireNonNull(accumulator);
        R sink = supplier.get();
        while (this.mIterator.hasNext()) {
            accumulator.accept(sink, this.mIterator.nextDouble());
        }
        return sink;
    }

    @Override
    public <E extends Throwable> DoubleExceptional<E> exception(Class<E> cls) {
        return new DoubleExceptionalImpl<E>(cls);
    }

    @Override
    public double sum() {
        double[] summation = this.collect(() -> new double[3], (ll, d) -> {
            KahanSummation.sumWithCompensation(ll, d);
            ll[2] = ll[2] + d;
        });
        return KahanSummation.computeFinalSum(summation);
    }

    @Override
    public OptionalDouble min() {
        return this.reduce(Math::min);
    }

    @Override
    public OptionalDouble max() {
        return this.reduce(Math::max);
    }

    @Override
    public long count() {
        return this.mapToLong(i -> 1L).sum();
    }

    @Override
    public DoubleStream sort() {
        return new DoubleStreamImpl(new DoubleChildIterator(() -> {
            double[] array = this.toArray();
            Arrays.sort(array);
            return new DoubleArrayIterator(array);
        }, Iterator::hasNext, DoubleIterator::nextDouble));
    }

    @Override
    public OptionalDouble average() {
        double[] avg = this.collect(() -> new double[4], (ll, d) -> {
            ll[2] = ll[2] + 1.0;
            KahanSummation.sumWithCompensation(ll, d);
            ll[3] = ll[3] + d;
        });
        return avg[2] > 0.0 ? OptionalDouble.of(KahanSummation.computeFinalSum(avg) / avg[2]) : OptionalDouble.empty();
    }

    @Override
    public OptionalDouble findFirst() {
        return this.mIterator.hasNext() ? OptionalDouble.of(this.mIterator.nextDouble()) : OptionalDouble.empty();
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextDouble())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.nextDouble())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextDouble())) continue;
            return false;
        }
        return true;
    }

    @Override
    public double[] toArray() {
        double[] tmp = new double[16];
        int index = 0;
        while (this.mIterator.hasNext()) {
            double c = this.mIterator.nextDouble();
            if (index >= tmp.length) {
                double[] newArray = new double[tmp.length * 2];
                System.arraycopy(tmp, 0, newArray, 0, tmp.length);
                tmp = newArray;
            }
            tmp[index++] = c;
        }
        double[] result = new double[index];
        System.arraycopy(tmp, 0, result, 0, index);
        return result;
    }

    private class DoubleExceptionalImpl<E extends Throwable>
    implements DoubleExceptional<E> {
        private final Class<E> mExceptionClass;

        public DoubleExceptionalImpl(Class<E> exceptionClass) {
            this.mExceptionClass = exceptionClass;
        }

        @Override
        public DoubleStream mapException(ToDoubleFunction<E> mapper) {
            DoubleStreamImpl.this.mIteratorWrapper.mapException(this.mExceptionClass, mapper);
            return DoubleStreamImpl.this;
        }

        @Override
        public DoubleStream consume(Consumer<E> consumer) {
            DoubleStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, consumer);
            return DoubleStreamImpl.this;
        }

        @Override
        public <I extends RuntimeException> DoubleStream rethrow(Function<E, I> mapper) {
            DoubleStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, e -> {
                throw (RuntimeException)mapper.apply(e);
            });
            return DoubleStreamImpl.this;
        }

        @Override
        public DoubleStream ignore() {
            DoubleStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, e -> {});
            return DoubleStreamImpl.this;
        }
    }

    private static class DummyIterator
    extends BaseIterator<Double>
    implements DoubleIterator {
        private double mValue;
        private boolean mHasNext;

        public DummyIterator(double value) {
            this(value, true);
        }

        public DummyIterator() {
            this(0.0, false);
        }

        private DummyIterator(double value, boolean hasNext) {
            this.mValue = value;
            this.mHasNext = hasNext;
        }

        public DummyIterator newValue(double value) {
            this.mValue = value;
            this.mHasNext = true;
            return this;
        }

        @Override
        public double nextDouble() {
            this.mHasNext = false;
            return this.mValue;
        }

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public Double next() {
            return this.nextDouble();
        }
    }
}

