/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.compat;

import android.support.v4.util.LongSparseArray;
import com.github.wrdlbrnft.streamcompat.function.LongFunction;
import com.github.wrdlbrnft.streamcompat.function.LongObjFunction;
import com.github.wrdlbrnft.streamcompat.util.Utils;

public class LongSparseArrayCompat {
    public static <V> V compute(LongSparseArray<V> map, long key, LongObjFunction<? super V, ? extends V> remappingFunction) {
        Utils.requireNonNull(map);
        Utils.requireNonNull(remappingFunction);
        Object oldValue = map.get(key);
        V newValue = remappingFunction.apply(key, oldValue);
        if (newValue == null) {
            if (oldValue != null) {
                map.remove(key);
            }
            return null;
        }
        map.put(key, newValue);
        return newValue;
    }

    public static <V> V putIfAbsent(LongSparseArray<V> map, long key, V value) {
        Object existingValue = map.get(key);
        if (existingValue != null) {
            return (V)existingValue;
        }
        map.put(key, value);
        return null;
    }

    public static <V> V computeIfAbsent(LongSparseArray<V> map, long key, LongFunction<? extends V> mappingFunction) {
        V newValue;
        Utils.requireNonNull(map);
        Utils.requireNonNull(mappingFunction);
        Object v = map.get(key);
        if (v == null && (newValue = mappingFunction.apply(key)) != null) {
            map.put(key, newValue);
            return newValue;
        }
        return (V)v;
    }

    public static <V> V computeIfPresent(LongSparseArray<V> map, long key, LongObjFunction<? super V, ? extends V> remappingFunction) {
        Utils.requireNonNull(map);
        Utils.requireNonNull(remappingFunction);
        Object oldValue = map.get(key);
        if (oldValue != null) {
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                map.put(key, newValue);
                return newValue;
            }
            map.remove(key);
        }
        return null;
    }

    public static <V> void replaceAll(LongSparseArray<V> map, LongObjFunction<? super V, ? extends V> function) {
        Utils.requireNonNull(map);
        Utils.requireNonNull(function);
        int count = map.size();
        for (int i = 0; i < count; ++i) {
            long key = map.keyAt(i);
            Object value = map.valueAt(i);
            map.setValueAt(i, function.apply(key, value));
        }
    }
}

