/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.bytestream;

import com.github.wrdlbrnft.streamcompat.bytestream.ByteStream;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteStreamImpl;
import com.github.wrdlbrnft.streamcompat.iterator.array.ArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.array.ByteArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ByteChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.ByteIterator;
import com.github.wrdlbrnft.streamcompat.util.EmptyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ByteStreamCompat {
    static final ByteIterator EMPTY_ITERATOR = new EmptyByteIterator();
    private static final ByteStream EMPTY_STREAM = new ByteStreamImpl(EMPTY_ITERATOR);

    public static ByteStream empty() {
        return EMPTY_STREAM;
    }

    public static ByteStream concat(ByteStream ... streams) {
        ArrayIterator<ByteStream> iterator = new ArrayIterator<ByteStream>(streams);
        ByteIterator[] buffer = new ByteIterator[1];
        return new ByteStreamImpl(new ByteChildIterator(() -> {
            if (buffer[0] == null || !buffer[0].hasNext()) {
                if (!iterator.hasNext()) {
                    return EMPTY_ITERATOR;
                }
                buffer[0] = ((ByteStream)iterator.next()).iterator();
            }
            return buffer[0];
        }, Iterator::hasNext, ByteIterator::nextByte));
    }

    public static ByteStream of(byte ... values) {
        ByteArrayIterator iterator = new ByteArrayIterator(values);
        return new ByteStreamImpl(iterator);
    }

    public static ByteStream of(ByteIterator iterator) {
        return new ByteStreamImpl(iterator);
    }

    private static class EmptyByteIterator
    extends EmptyIterator<Byte>
    implements ByteIterator {
        private EmptyByteIterator() {
        }

        @Override
        public byte nextByte() {
            throw new NoSuchElementException();
        }
    }
}

