/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.util;

import com.github.wrdlbrnft.streamcompat.util.Utils;

public class StringJoiner {
    private final String prefix;
    private final String delimiter;
    private final String suffix;
    private StringBuilder value;
    private String emptyValue;

    public StringJoiner(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        Utils.requireNonNull(prefix, "The prefix must not be null");
        Utils.requireNonNull(delimiter, "The delimiter must not be null");
        Utils.requireNonNull(suffix, "The suffix must not be null");
        this.prefix = prefix.toString();
        this.delimiter = delimiter.toString();
        this.suffix = suffix.toString();
        this.emptyValue = this.prefix + this.suffix;
    }

    public StringJoiner setEmptyValue(CharSequence emptyValue) {
        this.emptyValue = Utils.requireNonNull(emptyValue, "The empty value must not be null").toString();
        return this;
    }

    public String toString() {
        if (this.value == null) {
            return this.emptyValue;
        }
        if (this.suffix.equals("")) {
            return this.value.toString();
        }
        int initialLength = this.value.length();
        String result = this.value.append(this.suffix).toString();
        this.value.setLength(initialLength);
        return result;
    }

    public <T> StringJoiner add(T newElement) {
        this.prepareBuilder().append(newElement);
        return this;
    }

    public StringJoiner merge(StringJoiner other) {
        Utils.requireNonNull(other);
        if (other.value != null) {
            int length = other.value.length();
            this.prepareBuilder().append(other.value, other.prefix.length(), length);
        }
        return this;
    }

    private StringBuilder prepareBuilder() {
        if (this.value != null) {
            this.value.append(this.delimiter);
        } else {
            this.value = new StringBuilder().append(this.prefix);
        }
        return this.value;
    }

    public int length() {
        return this.value != null ? this.value.length() + this.suffix.length() : this.emptyValue.length();
    }
}

