/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.optionals;

import com.github.wrdlbrnft.streamcompat.function.IntConsumer;
import com.github.wrdlbrnft.streamcompat.function.IntSupplier;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.NoSuchElementException;

public class OptionalInt {
    private static final OptionalInt EMPTY = new OptionalInt();
    private final boolean mIsPresent;
    private final int mValue;

    private OptionalInt() {
        this.mIsPresent = false;
        this.mValue = 0;
    }

    public static OptionalInt empty() {
        return EMPTY;
    }

    private OptionalInt(int value) {
        this.mIsPresent = true;
        this.mValue = value;
    }

    public static OptionalInt of(int value) {
        return new OptionalInt(value);
    }

    public int getAsInt() {
        if (!this.mIsPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.mValue;
    }

    public boolean isPresent() {
        return this.mIsPresent;
    }

    public void ifPresent(IntConsumer consumer) {
        if (this.mIsPresent) {
            consumer.accept(this.mValue);
        }
    }

    public int orElse(int other) {
        return this.mIsPresent ? this.mValue : other;
    }

    public int orElseGet(IntSupplier other) {
        return this.mIsPresent ? this.mValue : other.getAsInt();
    }

    public <X extends Throwable> int orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.mIsPresent) {
            return this.mValue;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalInt)) {
            return false;
        }
        OptionalInt other = (OptionalInt)obj;
        return this.mIsPresent && other.mIsPresent ? this.mValue == other.mValue : this.mIsPresent == other.mIsPresent;
    }

    public int hashCode() {
        return this.mIsPresent ? Utils.hashCode(this.mValue) : 0;
    }

    public String toString() {
        return this.mIsPresent ? String.format("OptionalInt[%s]", this.mValue) : "OptionalInt.empty";
    }
}

