/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.collections.compat;

import android.util.SparseArray;
import com.github.wrdlbrnft.streamcompat.function.IntFunction;
import com.github.wrdlbrnft.streamcompat.function.IntObjFunction;
import com.github.wrdlbrnft.streamcompat.util.Utils;

public class SparseArrayCompat {
    public static <V> V compute(SparseArray<V> map, int key, IntObjFunction<? super V, ? extends V> remappingFunction) {
        Utils.requireNonNull(map);
        Utils.requireNonNull(remappingFunction);
        Object oldValue = map.get(key);
        V newValue = remappingFunction.apply(key, oldValue);
        if (newValue == null) {
            if (oldValue != null) {
                map.remove(key);
            }
            return null;
        }
        map.put(key, newValue);
        return newValue;
    }

    public static <V> V putIfAbsent(SparseArray<V> map, int key, V value) {
        Object existingValue = map.get(key);
        if (existingValue != null) {
            return (V)existingValue;
        }
        map.put(key, value);
        return null;
    }

    public static <V> V computeIfAbsent(SparseArray<V> map, int key, IntFunction<? extends V> mappingFunction) {
        V newValue;
        Utils.requireNonNull(map);
        Utils.requireNonNull(mappingFunction);
        Object v = map.get(key);
        if (v == null && (newValue = mappingFunction.apply(key)) != null) {
            map.put(key, newValue);
            return newValue;
        }
        return (V)v;
    }

    public static <V> V computeIfPresent(SparseArray<V> map, int key, IntObjFunction<? super V, ? extends V> remappingFunction) {
        Utils.requireNonNull(map);
        Utils.requireNonNull(remappingFunction);
        Object oldValue = map.get(key);
        if (oldValue != null) {
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                map.put(key, newValue);
                return newValue;
            }
            map.remove(key);
        }
        return null;
    }

    public static <V> void replaceAll(SparseArray<V> map, IntObjFunction<? super V, ? extends V> function) {
        Utils.requireNonNull(map);
        Utils.requireNonNull(function);
        int count = map.size();
        for (int i = 0; i < count; ++i) {
            int key = map.keyAt(i);
            Object value = map.valueAt(i);
            map.setValueAt(i, function.apply(key, value));
        }
    }
}

