/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.optionals;

import com.github.wrdlbrnft.streamcompat.function.FloatConsumer;
import com.github.wrdlbrnft.streamcompat.function.FloatSupplier;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.NoSuchElementException;

public class OptionalFloat {
    private static final OptionalFloat EMPTY = new OptionalFloat();
    private final boolean mIsPresent;
    private final float mValue;

    private OptionalFloat() {
        this.mIsPresent = false;
        this.mValue = Float.NaN;
    }

    public static OptionalFloat empty() {
        return EMPTY;
    }

    private OptionalFloat(float value) {
        this.mIsPresent = true;
        this.mValue = value;
    }

    public static OptionalFloat of(float value) {
        return new OptionalFloat(value);
    }

    public float getAsFloat() {
        if (!this.mIsPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.mValue;
    }

    public boolean isPresent() {
        return this.mIsPresent;
    }

    public void ifPresent(FloatConsumer consumer) {
        if (this.mIsPresent) {
            consumer.accept(this.mValue);
        }
    }

    public float orElse(float other) {
        return this.mIsPresent ? this.mValue : other;
    }

    public float orElseGet(FloatSupplier other) {
        return this.mIsPresent ? this.mValue : other.getAsFloat();
    }

    public <X extends Throwable> float orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.mIsPresent) {
            return this.mValue;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalFloat)) {
            return false;
        }
        OptionalFloat other = (OptionalFloat)obj;
        return this.mIsPresent && other.mIsPresent ? Float.compare(this.mValue, other.mValue) == 0 : this.mIsPresent == other.mIsPresent;
    }

    public int hashCode() {
        return this.mIsPresent ? Utils.hashCode(this.mValue) : 0;
    }

    public String toString() {
        return this.mIsPresent ? String.format("OptionalFloat[%s]", Float.valueOf(this.mValue)) : "OptionalFloat.empty";
    }
}

