/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.longstream;

import android.support.v4.util.LongSparseArray;
import com.github.wrdlbrnft.streamcompat.iterator.array.ArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.array.LongArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.LongChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.LongIterator;
import com.github.wrdlbrnft.streamcompat.iterator.sparsearray.LongSparseArrayKeyIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongRangeIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat$$Lambda$1;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat$$Lambda$2;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat$$Lambda$3;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamImpl;
import com.github.wrdlbrnft.streamcompat.util.EmptyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongStreamCompat {
    static final LongIterator EMPTY_ITERATOR = new EmptyLongIterator();
    private static final LongStreamImpl EMPTY_STREAM = new LongStreamImpl(EMPTY_ITERATOR);

    public static LongStream empty() {
        return EMPTY_STREAM;
    }

    public static LongStream concat(LongStream ... streams) {
        ArrayIterator<LongStream> iterator = new ArrayIterator<LongStream>(streams);
        LongIterator[] buffer = new LongIterator[1];
        return new LongStreamImpl(new LongChildIterator(LongStreamCompat$$Lambda$1.lambdaFactory$(buffer, iterator), LongStreamCompat$$Lambda$2.lambdaFactory$(), LongStreamCompat$$Lambda$3.lambdaFactory$()));
    }

    public static LongStream of(long ... values) {
        LongArrayIterator iterator = new LongArrayIterator(values);
        return new LongStreamImpl(iterator);
    }

    public static <T> LongStream ofKeys(LongSparseArray<T> array) {
        LongSparseArrayKeyIterator<T> iterator = new LongSparseArrayKeyIterator<T>(array);
        return new LongStreamImpl(iterator);
    }

    public static LongStream range(long start, long end) {
        if (end < start) {
            throw new IllegalArgumentException("End value must be bigger than start value!");
        }
        LongRangeIterator iterator = new LongRangeIterator(start, end);
        return new LongStreamImpl(iterator);
    }

    public static LongStream positiveLongIntegers() {
        LongRangeIterator iterator = new LongRangeIterator(0L, Long.MAX_VALUE);
        return new LongStreamImpl(iterator);
    }

    public static LongStream negativeLongIntegers() {
        LongRangeIterator iterator = new LongRangeIterator(0L, Long.MIN_VALUE);
        return new LongStreamImpl(iterator);
    }

    public static LongStream of(LongIterator iterator) {
        return new LongStreamImpl(iterator);
    }

    private static /* synthetic */ LongIterator lambda$concat$131(LongIterator[] buffer, Iterator iterator) {
        if (buffer[0] == null || !buffer[0].hasNext()) {
            if (!iterator.hasNext()) {
                return EMPTY_ITERATOR;
            }
            buffer[0] = ((LongStream)iterator.next()).iterator();
        }
        return buffer[0];
    }

    static /* synthetic */ LongIterator access$lambda$0(LongIterator[] longIteratorArray, Iterator iterator) {
        return LongStreamCompat.lambda$concat$131(longIteratorArray, iterator);
    }

    private static class EmptyLongIterator
    extends EmptyIterator<Long>
    implements LongIterator {
        private EmptyLongIterator() {
        }

        @Override
        public long nextLong() {
            throw new NoSuchElementException();
        }
    }
}

