/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.optionals;

import com.github.wrdlbrnft.streamcompat.function.ByteConsumer;
import com.github.wrdlbrnft.streamcompat.function.ByteSupplier;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.NoSuchElementException;

public class OptionalByte {
    private static final OptionalByte EMPTY = new OptionalByte();
    private final boolean mIsPresent;
    private final byte mValue;

    private OptionalByte() {
        this.mIsPresent = false;
        this.mValue = 0;
    }

    public static OptionalByte empty() {
        return EMPTY;
    }

    private OptionalByte(byte value) {
        this.mIsPresent = true;
        this.mValue = value;
    }

    public static OptionalByte of(byte value) {
        return new OptionalByte(value);
    }

    public byte getAsByte() {
        if (!this.mIsPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.mValue;
    }

    public boolean isPresent() {
        return this.mIsPresent;
    }

    public void ifPresent(ByteConsumer consumer) {
        if (this.mIsPresent) {
            consumer.accept(this.mValue);
        }
    }

    public byte orElse(byte other) {
        return this.mIsPresent ? this.mValue : other;
    }

    public byte orElseGet(ByteSupplier other) {
        return this.mIsPresent ? this.mValue : other.getAsByte();
    }

    public <X extends Throwable> byte orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.mIsPresent) {
            return this.mValue;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalByte)) {
            return false;
        }
        OptionalByte other = (OptionalByte)obj;
        return this.mIsPresent && other.mIsPresent ? this.mValue == other.mValue : this.mIsPresent == other.mIsPresent;
    }

    public int hashCode() {
        return this.mIsPresent ? Utils.hashCode(this.mValue) : 0;
    }

    public String toString() {
        return this.mIsPresent ? String.format("OptionalByte[%s]", this.mValue) : "OptionalByte.empty";
    }
}

