/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.intstream;

import android.util.SparseArray;
import com.github.wrdlbrnft.streamcompat.intstream.IntRangeIterator;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat$$Lambda$1;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat$$Lambda$2;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat$$Lambda$3;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamImpl;
import com.github.wrdlbrnft.streamcompat.iterator.array.ArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.array.IntArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.IntChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.IntIterator;
import com.github.wrdlbrnft.streamcompat.iterator.sparsearray.SparseArrayKeyIterator;
import com.github.wrdlbrnft.streamcompat.util.EmptyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntStreamCompat {
    static final IntIterator EMPTY_ITERATOR = new EmptyIntIterator();
    private static final IntStreamImpl EMPTY_STREAM = new IntStreamImpl(EMPTY_ITERATOR);

    public static IntStream empty() {
        return EMPTY_STREAM;
    }

    public static IntStream concat(IntStream ... streams) {
        ArrayIterator<IntStream> iterator = new ArrayIterator<IntStream>(streams);
        IntIterator[] buffer = new IntIterator[1];
        return new IntStreamImpl(new IntChildIterator(IntStreamCompat$$Lambda$1.lambdaFactory$(buffer, iterator), IntStreamCompat$$Lambda$2.lambdaFactory$(), IntStreamCompat$$Lambda$3.lambdaFactory$()));
    }

    public static IntStream of(int ... values) {
        IntArrayIterator iterator = new IntArrayIterator(values);
        return new IntStreamImpl(iterator);
    }

    public static <T> IntStream ofKeys(SparseArray<T> array) {
        SparseArrayKeyIterator<T> iterator = new SparseArrayKeyIterator<T>(array);
        return new IntStreamImpl(iterator);
    }

    public static IntStream range(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("End value must be bigger than start value!");
        }
        IntRangeIterator iterator = new IntRangeIterator(start, end);
        return new IntStreamImpl(iterator);
    }

    public static IntStream positiveIntegers() {
        IntRangeIterator iterator = new IntRangeIterator(0, Integer.MAX_VALUE);
        return new IntStreamImpl(iterator);
    }

    public static IntStream negativeIntegers() {
        IntRangeIterator iterator = new IntRangeIterator(0, Integer.MIN_VALUE);
        return new IntStreamImpl(iterator);
    }

    public static IntStream of(IntIterator iterator) {
        return new IntStreamImpl(iterator);
    }

    private static /* synthetic */ IntIterator lambda$concat$106(IntIterator[] buffer, Iterator iterator) {
        if (buffer[0] == null || !buffer[0].hasNext()) {
            if (!iterator.hasNext()) {
                return EMPTY_ITERATOR;
            }
            buffer[0] = ((IntStream)iterator.next()).iterator();
        }
        return buffer[0];
    }

    static /* synthetic */ IntIterator access$lambda$0(IntIterator[] intIteratorArray, Iterator iterator) {
        return IntStreamCompat.lambda$concat$106(intIteratorArray, iterator);
    }

    private static class EmptyIntIterator
    extends EmptyIterator<Integer>
    implements IntIterator {
        private EmptyIntIterator() {
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }
    }
}

