/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.floatstream;

import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStream;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamCompat;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$1;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$10;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$11;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$12;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$13;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$14;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$15;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$16;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$17;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$18;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$19;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$2;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$20;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$21;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$22;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$23;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$24;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$25;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$26;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$27;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$28;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$29;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$3;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$30;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$31;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$32;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$33;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$34;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$35;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$4;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$5;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$6;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$7;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$8;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$9;
import com.github.wrdlbrnft.streamcompat.function.FloatBinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.FloatConsumer;
import com.github.wrdlbrnft.streamcompat.function.FloatFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatPredicate;
import com.github.wrdlbrnft.streamcompat.function.FloatToCharFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatToDoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatToIntFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatToLongFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatUnaryOperator;
import com.github.wrdlbrnft.streamcompat.function.ObjFloatConsumer;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.CharChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.DoubleChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.FloatChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.IntChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.LongChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.FloatIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat;
import com.github.wrdlbrnft.streamcompat.optionals.OptionalFloat;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat;
import com.github.wrdlbrnft.streamcompat.util.KahanSummation;
import com.github.wrdlbrnft.streamcompat.util.Utils;

class FloatStreamImpl
implements FloatStream {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private final FloatIterator mIterator;

    FloatStreamImpl(FloatIterator iterator) {
        this.mIterator = iterator;
    }

    @Override
    public FloatStream filter(FloatPredicate predicate) {
        Utils.requireNonNull(predicate);
        DummyIterator iterator = new DummyIterator();
        return new FloatStreamImpl(new FloatChildIterator(FloatStreamImpl$$Lambda$1.lambdaFactory$(this, predicate, iterator), FloatStreamImpl$$Lambda$2.lambdaFactory$(), FloatStreamImpl$$Lambda$3.lambdaFactory$()));
    }

    @Override
    public FloatStream map(FloatUnaryOperator mapper) {
        Utils.requireNonNull(mapper);
        return new FloatStreamImpl(new FloatChildIterator(FloatStreamImpl$$Lambda$4.lambdaFactory$(this), FloatStreamImpl$$Lambda$5.lambdaFactory$(), FloatStreamImpl$$Lambda$6.lambdaFactory$(this, mapper)));
    }

    @Override
    public FloatStream flatMap(FloatFunction<? extends FloatStream> mapper) {
        Utils.requireNonNull(mapper);
        FloatIterator[] buffer = new FloatIterator[1];
        return new FloatStreamImpl(new FloatChildIterator(FloatStreamImpl$$Lambda$7.lambdaFactory$(this, buffer, mapper), FloatStreamImpl$$Lambda$8.lambdaFactory$(), FloatStreamImpl$$Lambda$9.lambdaFactory$()));
    }

    @Override
    public <U> Stream<U> mapToObj(FloatFunction<? extends U> mapper) {
        Utils.requireNonNull(mapper);
        return StreamCompat.of(new ChildIterator(FloatStreamImpl$$Lambda$10.lambdaFactory$(this), FloatStreamImpl$$Lambda$11.lambdaFactory$(), FloatStreamImpl$$Lambda$12.lambdaFactory$(this, mapper)));
    }

    @Override
    public LongStream mapToLong(FloatToLongFunction mapper) {
        Utils.requireNonNull(mapper);
        return LongStreamCompat.of(new LongChildIterator(FloatStreamImpl$$Lambda$13.lambdaFactory$(this), FloatStreamImpl$$Lambda$14.lambdaFactory$(), FloatStreamImpl$$Lambda$15.lambdaFactory$(this, mapper)));
    }

    @Override
    public IntStream mapToInt(FloatToIntFunction mapper) {
        Utils.requireNonNull(mapper);
        return IntStreamCompat.of(new IntChildIterator(FloatStreamImpl$$Lambda$16.lambdaFactory$(this), FloatStreamImpl$$Lambda$17.lambdaFactory$(), FloatStreamImpl$$Lambda$18.lambdaFactory$(this, mapper)));
    }

    @Override
    public CharacterStream mapToChar(FloatToCharFunction mapper) {
        Utils.requireNonNull(mapper);
        return CharacterStreamCompat.of(new CharChildIterator(FloatStreamImpl$$Lambda$19.lambdaFactory$(this), FloatStreamImpl$$Lambda$20.lambdaFactory$(), FloatStreamImpl$$Lambda$21.lambdaFactory$(this, mapper)));
    }

    @Override
    public DoubleStream mapToDouble(FloatToDoubleFunction mapper) {
        Utils.requireNonNull(mapper);
        return DoubleStreamCompat.of(new DoubleChildIterator(FloatStreamImpl$$Lambda$22.lambdaFactory$(this), FloatStreamImpl$$Lambda$23.lambdaFactory$(), FloatStreamImpl$$Lambda$24.lambdaFactory$(this, mapper)));
    }

    @Override
    public FloatIterator iterator() {
        return this.mIterator;
    }

    @Override
    public void forEach(FloatConsumer action) {
        Utils.requireNonNull(action);
        while (this.mIterator.hasNext()) {
            float value = this.mIterator.nextFloat();
            action.accept(value);
        }
    }

    @Override
    public Stream<Float> boxed() {
        return this.mapToObj(FloatStreamImpl$$Lambda$25.lambdaFactory$());
    }

    @Override
    public FloatStream limit(long limit) {
        long[] buffer = new long[]{0L, limit};
        return new FloatStreamImpl(new FloatChildIterator(FloatStreamImpl$$Lambda$26.lambdaFactory$(this), FloatStreamImpl$$Lambda$27.lambdaFactory$(this, buffer), FloatStreamImpl$$Lambda$28.lambdaFactory$(this, buffer)));
    }

    @Override
    public float reduce(float identity, FloatBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        float current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsFloat(current, this.mIterator.nextFloat());
        }
        return current;
    }

    @Override
    public OptionalFloat reduce(FloatBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        if (!this.mIterator.hasNext()) {
            return OptionalFloat.empty();
        }
        float current = this.mIterator.nextFloat();
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsFloat(current, this.mIterator.nextFloat());
        }
        return OptionalFloat.of(current);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjFloatConsumer<R> accumulator) {
        Utils.requireNonNull(supplier);
        Utils.requireNonNull(accumulator);
        R sink = supplier.get();
        while (this.mIterator.hasNext()) {
            accumulator.accept(sink, this.mIterator.nextFloat());
        }
        return sink;
    }

    @Override
    public float sum() {
        float[] summation = (float[])this.collect(FloatStreamImpl$$Lambda$29.lambdaFactory$(), FloatStreamImpl$$Lambda$30.lambdaFactory$());
        return KahanSummation.computeFinalSum(summation);
    }

    @Override
    public OptionalFloat min() {
        return this.reduce(FloatStreamImpl$$Lambda$31.lambdaFactory$());
    }

    @Override
    public OptionalFloat max() {
        return this.reduce(FloatStreamImpl$$Lambda$32.lambdaFactory$());
    }

    @Override
    public long count() {
        return this.mapToLong(FloatStreamImpl$$Lambda$33.lambdaFactory$()).sum();
    }

    @Override
    public OptionalFloat average() {
        float[] avg = (float[])this.collect(FloatStreamImpl$$Lambda$34.lambdaFactory$(), FloatStreamImpl$$Lambda$35.lambdaFactory$());
        return avg[2] > 0.0f ? OptionalFloat.of(KahanSummation.computeFinalSum(avg) / avg[2]) : OptionalFloat.empty();
    }

    @Override
    public OptionalFloat findFirst() {
        return this.mIterator.hasNext() ? OptionalFloat.of(this.mIterator.nextFloat()) : OptionalFloat.empty();
    }

    @Override
    public boolean anyMatch(FloatPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextFloat())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(FloatPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.nextFloat())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(FloatPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextFloat())) continue;
            return false;
        }
        return true;
    }

    @Override
    public float[] toArray() {
        float[] tmp = new float[16];
        int index = 0;
        while (this.mIterator.hasNext()) {
            float c = this.mIterator.nextFloat();
            if (index >= tmp.length) {
                float[] newArray = new float[tmp.length * 2];
                System.arraycopy(tmp, 0, newArray, 0, tmp.length);
                tmp = newArray;
            }
            tmp[index++] = c;
        }
        float[] result = new float[index];
        System.arraycopy(tmp, 0, result, 0, index);
        return result;
    }

    private static /* synthetic */ void lambda$average$69(float[] ll, float d) {
        ll[2] = ll[2] + 1.0f;
        KahanSummation.sumWithCompensation(ll, d);
        ll[3] = ll[3] + d;
    }

    private static /* synthetic */ float[] lambda$average$68() {
        return new float[4];
    }

    private static /* synthetic */ long lambda$count$67(float i) {
        return 1L;
    }

    private static /* synthetic */ void lambda$sum$66(float[] ll, float d) {
        KahanSummation.sumWithCompensation(ll, d);
        ll[2] = ll[2] + d;
    }

    private static /* synthetic */ float[] lambda$sum$65() {
        return new float[3];
    }

    private /* synthetic */ float lambda$limit$64(long[] buffer, FloatIterator iterator) {
        buffer[0] = buffer[0] + 1L;
        return this.mIterator.nextFloat();
    }

    private /* synthetic */ boolean lambda$limit$63(long[] buffer, FloatIterator iterator) {
        return buffer[0] < buffer[1] && this.mIterator.hasNext();
    }

    private /* synthetic */ FloatIterator lambda$limit$62() {
        return this.mIterator;
    }

    private /* synthetic */ double lambda$mapToDouble$61(FloatToDoubleFunction mapper, FloatIterator iterator) {
        return mapper.applyAsDouble(this.mIterator.nextFloat());
    }

    private /* synthetic */ FloatIterator lambda$mapToDouble$60() {
        return this.mIterator;
    }

    private /* synthetic */ char lambda$mapToChar$59(FloatToCharFunction mapper, FloatIterator iterator) {
        return mapper.applyAsChar(this.mIterator.nextFloat());
    }

    private /* synthetic */ FloatIterator lambda$mapToChar$58() {
        return this.mIterator;
    }

    private /* synthetic */ int lambda$mapToInt$57(FloatToIntFunction mapper, FloatIterator iterator) {
        return mapper.applyAsInt(this.mIterator.nextFloat());
    }

    private /* synthetic */ FloatIterator lambda$mapToInt$56() {
        return this.mIterator;
    }

    private /* synthetic */ long lambda$mapToLong$55(FloatToLongFunction mapper, FloatIterator iterator) {
        return mapper.applyAsLong(this.mIterator.nextFloat());
    }

    private /* synthetic */ FloatIterator lambda$mapToLong$54() {
        return this.mIterator;
    }

    private /* synthetic */ Object lambda$mapToObj$53(FloatFunction mapper, FloatIterator iterator) {
        return mapper.apply(this.mIterator.nextFloat());
    }

    private /* synthetic */ FloatIterator lambda$mapToObj$52() {
        return this.mIterator;
    }

    private /* synthetic */ FloatIterator lambda$flatMap$51(FloatIterator[] buffer, FloatFunction mapper) {
        if (buffer[0] == null || !buffer[0].hasNext()) {
            if (!this.mIterator.hasNext()) {
                return FloatStreamCompat.EMPTY_ITERATOR;
            }
            buffer[0] = ((FloatStream)mapper.apply(this.mIterator.nextFloat())).iterator();
        }
        return buffer[0];
    }

    private /* synthetic */ float lambda$map$50(FloatUnaryOperator mapper, FloatIterator iterator) {
        return mapper.applyAsFloat(this.mIterator.nextFloat());
    }

    private /* synthetic */ FloatIterator lambda$map$49() {
        return this.mIterator;
    }

    private /* synthetic */ DummyIterator lambda$filter$48(FloatPredicate predicate, DummyIterator iterator) {
        while (this.mIterator.hasNext()) {
            float value = this.mIterator.nextFloat();
            if (!predicate.test(value)) continue;
            return iterator.newValue(value);
        }
        return iterator;
    }

    static /* synthetic */ DummyIterator access$lambda$0(FloatStreamImpl floatStreamImpl, FloatPredicate floatPredicate, DummyIterator dummyIterator) {
        return floatStreamImpl.lambda$filter$48(floatPredicate, dummyIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$1(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$map$49();
    }

    static /* synthetic */ float access$lambda$2(FloatStreamImpl floatStreamImpl, FloatUnaryOperator floatUnaryOperator, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$map$50(floatUnaryOperator, floatIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$3(FloatStreamImpl floatStreamImpl, FloatIterator[] floatIteratorArray, FloatFunction floatFunction) {
        return floatStreamImpl.lambda$flatMap$51(floatIteratorArray, floatFunction);
    }

    static /* synthetic */ FloatIterator access$lambda$4(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$mapToObj$52();
    }

    static /* synthetic */ Object access$lambda$5(FloatStreamImpl floatStreamImpl, FloatFunction floatFunction, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$mapToObj$53(floatFunction, floatIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$6(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$mapToLong$54();
    }

    static /* synthetic */ long access$lambda$7(FloatStreamImpl floatStreamImpl, FloatToLongFunction floatToLongFunction, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$mapToLong$55(floatToLongFunction, floatIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$8(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$mapToInt$56();
    }

    static /* synthetic */ int access$lambda$9(FloatStreamImpl floatStreamImpl, FloatToIntFunction floatToIntFunction, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$mapToInt$57(floatToIntFunction, floatIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$10(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$mapToChar$58();
    }

    static /* synthetic */ char access$lambda$11(FloatStreamImpl floatStreamImpl, FloatToCharFunction floatToCharFunction, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$mapToChar$59(floatToCharFunction, floatIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$12(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$mapToDouble$60();
    }

    static /* synthetic */ double access$lambda$13(FloatStreamImpl floatStreamImpl, FloatToDoubleFunction floatToDoubleFunction, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$mapToDouble$61(floatToDoubleFunction, floatIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$14(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$limit$62();
    }

    static /* synthetic */ boolean access$lambda$15(FloatStreamImpl floatStreamImpl, long[] lArray, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$limit$63(lArray, floatIterator);
    }

    static /* synthetic */ float access$lambda$16(FloatStreamImpl floatStreamImpl, long[] lArray, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$limit$64(lArray, floatIterator);
    }

    static /* synthetic */ float[] access$lambda$17() {
        return FloatStreamImpl.lambda$sum$65();
    }

    static /* synthetic */ void access$lambda$18(float[] fArray, float f) {
        FloatStreamImpl.lambda$sum$66(fArray, f);
    }

    static /* synthetic */ long access$lambda$19(float f) {
        return FloatStreamImpl.lambda$count$67(f);
    }

    static /* synthetic */ float[] access$lambda$20() {
        return FloatStreamImpl.lambda$average$68();
    }

    static /* synthetic */ void access$lambda$21(float[] fArray, float f) {
        FloatStreamImpl.lambda$average$69(fArray, f);
    }

    private static class DummyIterator
    extends BaseIterator<Float>
    implements FloatIterator {
        private float mValue;
        private boolean mHasNext;

        public DummyIterator(float value) {
            this(value, true);
        }

        public DummyIterator() {
            this(0.0f, false);
        }

        private DummyIterator(float value, boolean hasNext) {
            this.mValue = value;
            this.mHasNext = hasNext;
        }

        public DummyIterator newValue(float value) {
            this.mValue = value;
            this.mHasNext = true;
            return this;
        }

        @Override
        public float nextFloat() {
            this.mHasNext = false;
            return this.mValue;
        }

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public Float next() {
            return Float.valueOf(this.nextFloat());
        }
    }
}

