/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.intstream;

import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStream;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamCompat;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamCompat;
import com.github.wrdlbrnft.streamcompat.function.IntBinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.IntFunction;
import com.github.wrdlbrnft.streamcompat.function.IntPredicate;
import com.github.wrdlbrnft.streamcompat.function.IntToCharFunction;
import com.github.wrdlbrnft.streamcompat.function.IntToDoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.IntToFloatFunction;
import com.github.wrdlbrnft.streamcompat.function.IntToLongFunction;
import com.github.wrdlbrnft.streamcompat.function.IntUnaryOperator;
import com.github.wrdlbrnft.streamcompat.function.ObjIntConsumer;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.intstream.IntFlatMappingIterator;
import com.github.wrdlbrnft.streamcompat.intstream.IntLimitIterator;
import com.github.wrdlbrnft.streamcompat.intstream.IntMappingIterator;
import com.github.wrdlbrnft.streamcompat.intstream.IntPredicateIterator;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamImpl$$Lambda$1;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamImpl$$Lambda$2;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamImpl$$Lambda$3;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamImpl$$Lambda$4;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamImpl$$Lambda$5;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamImpl$$Lambda$6;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamImpl$$Lambda$7;
import com.github.wrdlbrnft.streamcompat.intstream.IntToCharMappingIterator;
import com.github.wrdlbrnft.streamcompat.intstream.IntToDoubleMappingIterator;
import com.github.wrdlbrnft.streamcompat.intstream.IntToFloatMappingIterator;
import com.github.wrdlbrnft.streamcompat.intstream.IntToLongMappingIterator;
import com.github.wrdlbrnft.streamcompat.intstream.IntToObjectMappingIterator;
import com.github.wrdlbrnft.streamcompat.iterator.IntIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat;
import com.github.wrdlbrnft.streamcompat.util.OptionalDouble;
import com.github.wrdlbrnft.streamcompat.util.OptionalInt;
import com.github.wrdlbrnft.streamcompat.util.Utils;

class IntStreamImpl
implements IntStream {
    private final IntIterator mIterator;

    IntStreamImpl(IntIterator iterator) {
        this.mIterator = iterator;
    }

    @Override
    public IntStream filter(IntPredicate predicate) {
        Utils.requireNonNull(predicate);
        IntPredicateIterator iterator = new IntPredicateIterator(this.mIterator, predicate);
        return new IntStreamImpl(iterator);
    }

    @Override
    public IntStream map(IntUnaryOperator mapper) {
        Utils.requireNonNull(mapper);
        IntMappingIterator iterator = new IntMappingIterator(this.mIterator, mapper);
        return new IntStreamImpl(iterator);
    }

    @Override
    public IntStream flatMap(IntFunction<? extends IntStream> mapper) {
        Utils.requireNonNull(mapper);
        IntFlatMappingIterator iterator = new IntFlatMappingIterator(this.mIterator, mapper);
        return new IntStreamImpl(iterator);
    }

    @Override
    public <U> Stream<U> mapToObj(IntFunction<? extends U> mapper) {
        Utils.requireNonNull(mapper);
        IntToObjectMappingIterator<? extends U> iterator = new IntToObjectMappingIterator<U>(this.mIterator, mapper);
        return StreamCompat.of(iterator);
    }

    @Override
    public LongStream mapToLong(IntToLongFunction mapper) {
        Utils.requireNonNull(mapper);
        IntToLongMappingIterator iterator = new IntToLongMappingIterator(this.mIterator, mapper);
        return LongStreamCompat.of(iterator);
    }

    @Override
    public DoubleStream mapToDouble(IntToDoubleFunction mapper) {
        Utils.requireNonNull(mapper);
        IntToDoubleMappingIterator iterator = new IntToDoubleMappingIterator(this.mIterator, mapper);
        return DoubleStreamCompat.of(iterator);
    }

    @Override
    public FloatStream mapToFloat(IntToFloatFunction mapper) {
        Utils.requireNonNull(mapper);
        IntToFloatMappingIterator iterator = new IntToFloatMappingIterator(this.mIterator, mapper);
        return FloatStreamCompat.of(iterator);
    }

    @Override
    public CharacterStream mapToChar(IntToCharFunction mapper) {
        Utils.requireNonNull(mapper);
        IntToCharMappingIterator iterator = new IntToCharMappingIterator(this.mIterator, mapper);
        return CharacterStreamCompat.of(iterator);
    }

    @Override
    public IntIterator iterator() {
        return this.mIterator;
    }

    @Override
    public Stream<Integer> boxed() {
        return this.mapToObj(IntStreamImpl$$Lambda$1.lambdaFactory$());
    }

    @Override
    public IntStream limit(long limit) {
        IntLimitIterator iterator = new IntLimitIterator(this.mIterator, limit);
        return new IntStreamImpl(iterator);
    }

    @Override
    public int reduce(int identity, IntBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        int current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsInt(current, this.mIterator.nextInt());
        }
        return current;
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        if (!this.mIterator.hasNext()) {
            return OptionalInt.empty();
        }
        int current = this.mIterator.nextInt();
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsInt(current, this.mIterator.nextInt());
        }
        return OptionalInt.of(current);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator) {
        Utils.requireNonNull(supplier);
        Utils.requireNonNull(accumulator);
        R sink = supplier.get();
        while (this.mIterator.hasNext()) {
            accumulator.accept(sink, this.mIterator.nextInt());
        }
        return sink;
    }

    @Override
    public int sum() {
        return this.reduce(0, IntStreamImpl$$Lambda$2.lambdaFactory$());
    }

    @Override
    public OptionalInt min() {
        return this.reduce(IntStreamImpl$$Lambda$3.lambdaFactory$());
    }

    @Override
    public OptionalInt max() {
        return this.reduce(IntStreamImpl$$Lambda$4.lambdaFactory$());
    }

    @Override
    public long count() {
        return this.mapToLong(IntStreamImpl$$Lambda$5.lambdaFactory$()).sum();
    }

    @Override
    public OptionalDouble average() {
        long[] avg = (long[])this.collect(IntStreamImpl$$Lambda$6.lambdaFactory$(), IntStreamImpl$$Lambda$7.lambdaFactory$());
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public OptionalInt findFirst() {
        return this.mIterator.hasNext() ? OptionalInt.of(this.mIterator.nextInt()) : OptionalInt.empty();
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextInt())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.nextInt())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextInt())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$average$19(long[] ll, int i) {
        ll[0] = ll[0] + 1L;
        ll[1] = ll[1] + (long)i;
    }

    private static /* synthetic */ long[] lambda$average$18() {
        return new long[2];
    }

    private static /* synthetic */ long lambda$count$17(int i) {
        return 1L;
    }

    private static /* synthetic */ int lambda$sum$16(int a, int b) {
        return a + b;
    }

    static /* synthetic */ int access$lambda$0(int n, int n2) {
        return IntStreamImpl.lambda$sum$16(n, n2);
    }

    static /* synthetic */ long access$lambda$1(int n) {
        return IntStreamImpl.lambda$count$17(n);
    }

    static /* synthetic */ long[] access$lambda$2() {
        return IntStreamImpl.lambda$average$18();
    }

    static /* synthetic */ void access$lambda$3(long[] lArray, int n) {
        IntStreamImpl.lambda$average$19(lArray, n);
    }
}

