/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.intstream;

import com.github.wrdlbrnft.streamcompat.function.IntPredicate;
import com.github.wrdlbrnft.streamcompat.iterator.IntIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIntIterator;
import java.util.NoSuchElementException;

class IntPredicateIterator
extends BaseIntIterator
implements IntIterator {
    private final IntIterator mBaseIterator;
    private final IntPredicate mPredicate;
    private int mNext;
    private boolean mHasNext;

    IntPredicateIterator(IntIterator baseIterator, IntPredicate predicate) {
        this.mBaseIterator = baseIterator;
        this.mPredicate = predicate;
        this.moveToNext();
    }

    private void moveToNext() {
        while (this.mBaseIterator.hasNext()) {
            int item = (Integer)this.mBaseIterator.next();
            if (!this.mPredicate.test(item)) continue;
            this.mNext = item;
            this.mHasNext = true;
            return;
        }
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public int nextInt() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        int current = this.mNext;
        this.moveToNext();
        return current;
    }
}

