/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.characterstream;

import com.github.wrdlbrnft.streamcompat.characterstream.CharacterFlatMappingIterator;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterLimitIterator;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterMappingIterator;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterPredicateIterator;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStream;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamImpl$$Lambda$1;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamImpl$$Lambda$2;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamImpl$$Lambda$3;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamImpl$$Lambda$4;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamImpl$$Lambda$5;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamImpl$$Lambda$6;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamImpl$$Lambda$7;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterToDoubleMappingIterator;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterToFloatMappingIterator;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterToIntMappingIterator;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterToLongMappingIterator;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterToObjectMappingIterator;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamCompat;
import com.github.wrdlbrnft.streamcompat.function.CharBinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.CharFunction;
import com.github.wrdlbrnft.streamcompat.function.CharPredicate;
import com.github.wrdlbrnft.streamcompat.function.CharToDoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.CharToFloatFunction;
import com.github.wrdlbrnft.streamcompat.function.CharToIntFunction;
import com.github.wrdlbrnft.streamcompat.function.CharToLongFunction;
import com.github.wrdlbrnft.streamcompat.function.CharUnaryOperator;
import com.github.wrdlbrnft.streamcompat.function.ObjCharConsumer;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat;
import com.github.wrdlbrnft.streamcompat.iterator.CharIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat;
import com.github.wrdlbrnft.streamcompat.util.OptionalCharacter;
import com.github.wrdlbrnft.streamcompat.util.OptionalDouble;
import com.github.wrdlbrnft.streamcompat.util.Utils;

class CharacterStreamImpl
implements CharacterStream {
    private final CharIterator mIterator;

    CharacterStreamImpl(CharIterator iterator) {
        this.mIterator = iterator;
    }

    @Override
    public CharacterStream filter(CharPredicate predicate) {
        Utils.requireNonNull(predicate);
        CharacterPredicateIterator iterator = new CharacterPredicateIterator(this.mIterator, predicate);
        return new CharacterStreamImpl(iterator);
    }

    @Override
    public CharacterStream map(CharUnaryOperator mapper) {
        Utils.requireNonNull(mapper);
        CharacterMappingIterator iterator = new CharacterMappingIterator(this.mIterator, mapper);
        return new CharacterStreamImpl(iterator);
    }

    @Override
    public CharacterStream flatMap(CharFunction<? extends CharacterStream> mapper) {
        Utils.requireNonNull(mapper);
        CharacterFlatMappingIterator iterator = new CharacterFlatMappingIterator(this.mIterator, mapper);
        return new CharacterStreamImpl(iterator);
    }

    @Override
    public <U> Stream<U> mapToObj(CharFunction<? extends U> mapper) {
        Utils.requireNonNull(mapper);
        CharacterToObjectMappingIterator<? extends U> iterator = new CharacterToObjectMappingIterator<U>(this.mIterator, mapper);
        return StreamCompat.of(iterator);
    }

    @Override
    public LongStream mapToLong(CharToLongFunction mapper) {
        Utils.requireNonNull(mapper);
        CharacterToLongMappingIterator iterator = new CharacterToLongMappingIterator(this.mIterator, mapper);
        return LongStreamCompat.of(iterator);
    }

    @Override
    public IntStream mapToInt(CharToIntFunction mapper) {
        Utils.requireNonNull(mapper);
        CharacterToIntMappingIterator iterator = new CharacterToIntMappingIterator(this.mIterator, mapper);
        return IntStreamCompat.of(iterator);
    }

    @Override
    public DoubleStream mapToDouble(CharToDoubleFunction mapper) {
        Utils.requireNonNull(mapper);
        CharacterToDoubleMappingIterator iterator = new CharacterToDoubleMappingIterator(this.mIterator, mapper);
        return DoubleStreamCompat.of(iterator);
    }

    @Override
    public FloatStream mapToFloat(CharToFloatFunction mapper) {
        Utils.requireNonNull(mapper);
        CharacterToFloatMappingIterator iterator = new CharacterToFloatMappingIterator(this.mIterator, mapper);
        return FloatStreamCompat.of(iterator);
    }

    @Override
    public CharIterator iterator() {
        return this.mIterator;
    }

    @Override
    public Stream<Character> boxed() {
        return this.mapToObj(CharacterStreamImpl$$Lambda$1.lambdaFactory$());
    }

    @Override
    public CharacterStream limit(long limit) {
        CharacterLimitIterator iterator = new CharacterLimitIterator(this.mIterator, limit);
        return new CharacterStreamImpl(iterator);
    }

    @Override
    public char reduce(char identity, CharBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        char current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsChar(current, this.mIterator.nextChar());
        }
        return current;
    }

    @Override
    public OptionalCharacter reduce(CharBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        if (!this.mIterator.hasNext()) {
            return OptionalCharacter.empty();
        }
        char current = this.mIterator.nextChar();
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsChar(current, this.mIterator.nextChar());
        }
        return OptionalCharacter.of(current);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjCharConsumer<R> accumulator) {
        Utils.requireNonNull(supplier);
        Utils.requireNonNull(accumulator);
        R sink = supplier.get();
        while (this.mIterator.hasNext()) {
            accumulator.accept(sink, this.mIterator.nextChar());
        }
        return sink;
    }

    @Override
    public char sum() {
        return this.reduce('\u0000', CharacterStreamImpl$$Lambda$2.lambdaFactory$());
    }

    @Override
    public OptionalCharacter min() {
        return this.reduce(CharacterStreamImpl$$Lambda$3.lambdaFactory$());
    }

    @Override
    public OptionalCharacter max() {
        return this.reduce(CharacterStreamImpl$$Lambda$4.lambdaFactory$());
    }

    @Override
    public long count() {
        return this.mapToLong(CharacterStreamImpl$$Lambda$5.lambdaFactory$()).sum();
    }

    @Override
    public OptionalDouble average() {
        long[] avg = (long[])this.collect(CharacterStreamImpl$$Lambda$6.lambdaFactory$(), CharacterStreamImpl$$Lambda$7.lambdaFactory$());
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public OptionalCharacter findFirst() {
        return this.mIterator.hasNext() ? OptionalCharacter.of(this.mIterator.nextChar()) : OptionalCharacter.empty();
    }

    @Override
    public boolean anyMatch(CharPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextChar())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(CharPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.nextChar())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(CharPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextChar())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$average$5(long[] ll, char i) {
        ll[0] = ll[0] + 1L;
        ll[1] = ll[1] + (long)i;
    }

    private static /* synthetic */ long[] lambda$average$4() {
        return new long[2];
    }

    private static /* synthetic */ long lambda$count$3(char i) {
        return 1L;
    }

    private static /* synthetic */ char lambda$max$2(char a, char b) {
        return a < b ? b : a;
    }

    private static /* synthetic */ char lambda$min$1(char a, char b) {
        return a < b ? a : b;
    }

    private static /* synthetic */ char lambda$sum$0(char a, char b) {
        return (char)(a + b);
    }

    static /* synthetic */ char access$lambda$0(char c, char c2) {
        return CharacterStreamImpl.lambda$sum$0(c, c2);
    }

    static /* synthetic */ char access$lambda$1(char c, char c2) {
        return CharacterStreamImpl.lambda$min$1(c, c2);
    }

    static /* synthetic */ char access$lambda$2(char c, char c2) {
        return CharacterStreamImpl.lambda$max$2(c, c2);
    }

    static /* synthetic */ long access$lambda$3(char c) {
        return CharacterStreamImpl.lambda$count$3(c);
    }

    static /* synthetic */ long[] access$lambda$4() {
        return CharacterStreamImpl.lambda$average$4();
    }

    static /* synthetic */ void access$lambda$5(long[] lArray, char c) {
        CharacterStreamImpl.lambda$average$5(lArray, c);
    }
}

