/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.util;

import com.github.wrdlbrnft.streamcompat.function.CharConsumer;
import com.github.wrdlbrnft.streamcompat.function.CharSupplier;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.NoSuchElementException;

public class OptionalCharacter {
    private static final OptionalCharacter EMPTY = new OptionalCharacter();
    private final boolean mIsPresent;
    private final char mValue;

    private OptionalCharacter() {
        this.mIsPresent = false;
        this.mValue = '\u0000';
    }

    public static OptionalCharacter empty() {
        return EMPTY;
    }

    private OptionalCharacter(char value) {
        this.mIsPresent = true;
        this.mValue = value;
    }

    public static OptionalCharacter of(char value) {
        return new OptionalCharacter(value);
    }

    public char getAsCharacter() {
        if (!this.mIsPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.mValue;
    }

    public boolean isPresent() {
        return this.mIsPresent;
    }

    public void ifPresent(CharConsumer consumer) {
        if (this.mIsPresent) {
            consumer.accept(this.mValue);
        }
    }

    public char orElse(char other) {
        return this.mIsPresent ? this.mValue : other;
    }

    public char orElseGet(CharSupplier other) {
        return this.mIsPresent ? this.mValue : other.getAsChar();
    }

    public <X extends Throwable> char orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.mIsPresent) {
            return this.mValue;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalCharacter)) {
            return false;
        }
        OptionalCharacter other = (OptionalCharacter)obj;
        return this.mIsPresent && other.mIsPresent ? this.mValue == other.mValue : this.mIsPresent == other.mIsPresent;
    }

    public int hashCode() {
        return this.mIsPresent ? Utils.hashCode(this.mValue) : 0;
    }

    public String toString() {
        return this.mIsPresent ? String.format("OptionalChar[%s]", Character.valueOf(this.mValue)) : "OptionalChar.empty";
    }
}

