/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.util;

import com.github.wrdlbrnft.streamcompat.function.Consumer;
import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.function.Predicate;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.NoSuchElementException;

public class Optional<T> {
    private static final Optional<?> EMPTY = new Optional();
    private final T mValue;

    private Optional() {
        this.mValue = null;
    }

    public static <T> Optional<T> empty() {
        Optional<?> t = EMPTY;
        return t;
    }

    private Optional(T value) {
        this.mValue = Utils.requireNonNull(value);
    }

    public static <T> Optional<T> of(T value) {
        return new Optional<T>(value);
    }

    public static <T> Optional<T> ofNullable(T value) {
        return value == null ? Optional.empty() : Optional.of(value);
    }

    public T get() {
        if (this.mValue == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.mValue;
    }

    public boolean isPresent() {
        return this.mValue != null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.mValue != null) {
            consumer.accept(this.mValue);
        }
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        Utils.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.mValue) ? this : Optional.empty();
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Utils.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.mValue));
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        Utils.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Utils.requireNonNull(mapper.apply(this.mValue));
    }

    public T orElse(T other) {
        return this.mValue != null ? this.mValue : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.mValue != null ? this.mValue : other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.mValue != null) {
            return this.mValue;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Optional)) {
            return false;
        }
        Optional other = (Optional)obj;
        return Utils.equals(this.mValue, other.mValue);
    }

    public int hashCode() {
        return Utils.hashCode(this.mValue);
    }

    public String toString() {
        return this.mValue != null ? String.format("Optional[%s]", this.mValue) : "Optional.empty";
    }
}

