/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.stream;

import com.github.wrdlbrnft.streamcompat.iterator.CharArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.DoubleArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.FloatArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.IntArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.LongArrayIterator;
import com.github.wrdlbrnft.streamcompat.stream.ArrayIterator;
import com.github.wrdlbrnft.streamcompat.stream.ImmutableIterator;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamImpl;
import java.util.Iterator;

public class StreamCompat {
    public static <S> Stream<S> of(Iterable<S> collection) {
        ImmutableIterator<S> iterator = new ImmutableIterator<S>(collection.iterator());
        return new StreamImpl<S>(iterator);
    }

    public static <S> Stream<S> of(Iterator<S> iterator) {
        return new StreamImpl<S>(iterator);
    }

    @SafeVarargs
    public static <S> Stream<S> of(S ... items) {
        ArrayIterator<S> iterator = new ArrayIterator<S>(items);
        return new StreamImpl<S>(iterator);
    }

    public static Stream<Character> of(char[] items) {
        CharArrayIterator iterator = new CharArrayIterator(items);
        return new StreamImpl<Character>(iterator);
    }

    public static Stream<Integer> of(int[] items) {
        IntArrayIterator iterator = new IntArrayIterator(items);
        return new StreamImpl<Integer>(iterator);
    }

    public static Stream<Long> of(long[] items) {
        LongArrayIterator iterator = new LongArrayIterator(items);
        return new StreamImpl<Long>(iterator);
    }

    public static Stream<Float> of(float[] items) {
        FloatArrayIterator iterator = new FloatArrayIterator(items);
        return new StreamImpl<Float>(iterator);
    }

    public static Stream<Double> of(double[] items) {
        DoubleArrayIterator iterator = new DoubleArrayIterator(items);
        return new StreamImpl<Double>(iterator);
    }
}

