/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.stream;

import com.github.wrdlbrnft.streamcompat.function.Predicate;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

class PredicateIterator<T>
extends BaseIterator<T>
implements Iterator<T> {
    private final Iterator<T> mBaseIterator;
    private final Predicate<T> mPredicate;
    private T mNext;
    private boolean mHasNext;

    PredicateIterator(Iterator<T> baseIterator, Predicate<T> predicate) {
        this.mBaseIterator = baseIterator;
        this.mPredicate = predicate;
        this.moveToNext();
    }

    private void moveToNext() {
        while (this.mBaseIterator.hasNext()) {
            T item = this.mBaseIterator.next();
            if (!this.mPredicate.test(item)) continue;
            this.mNext = item;
            this.mHasNext = true;
            return;
        }
        this.mNext = null;
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public T next() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        T current = this.mNext;
        this.moveToNext();
        return current;
    }
}

