/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.stream;

import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.iterator.IntIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIntIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

class FlatMapToIntIterator<I>
extends BaseIntIterator {
    private final Iterator<I> mBaseIterator;
    private final Function<? super I, ? extends IntStream> mMapper;
    private IntIterator mChild = null;
    private boolean mHasNext;
    private int mNext;

    public FlatMapToIntIterator(Iterator<I> iterator, Function<? super I, ? extends IntStream> mapper) {
        this.mBaseIterator = iterator;
        this.mMapper = mapper;
        this.moveToNext();
    }

    private void moveToNext() {
        if (this.mChild != null && this.mChild.hasNext()) {
            this.mHasNext = true;
            this.mNext = this.mChild.nextInt();
            return;
        }
        this.mChild = null;
        while (this.mBaseIterator.hasNext()) {
            I input = this.mBaseIterator.next();
            IntStream stream = this.mMapper.apply(input);
            this.mChild = stream.iterator();
            if (this.mChild == null || !this.mChild.hasNext()) continue;
            this.mHasNext = true;
            this.mNext = this.mChild.nextInt();
            return;
        }
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public int nextInt() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        int current = this.mNext;
        this.moveToNext();
        return current;
    }
}

