/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.longstream;

import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStream;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamCompat;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamCompat;
import com.github.wrdlbrnft.streamcompat.function.LongBinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.LongFunction;
import com.github.wrdlbrnft.streamcompat.function.LongPredicate;
import com.github.wrdlbrnft.streamcompat.function.LongToCharFunction;
import com.github.wrdlbrnft.streamcompat.function.LongToDoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.LongToFloatFunction;
import com.github.wrdlbrnft.streamcompat.function.LongToIntFunction;
import com.github.wrdlbrnft.streamcompat.function.LongUnaryOperator;
import com.github.wrdlbrnft.streamcompat.function.ObjLongConsumer;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat;
import com.github.wrdlbrnft.streamcompat.iterator.LongIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongFlatMappingIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongLimitIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongMappingIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongPredicateIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamImpl$$Lambda$1;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamImpl$$Lambda$2;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamImpl$$Lambda$3;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamImpl$$Lambda$4;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamImpl$$Lambda$5;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamImpl$$Lambda$6;
import com.github.wrdlbrnft.streamcompat.longstream.LongToCharMappingIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongToDoubleMappingIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongToFloatMappingIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongToIntMappingIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongToObjectMappingIterator;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat;
import com.github.wrdlbrnft.streamcompat.util.OptionalDouble;
import com.github.wrdlbrnft.streamcompat.util.OptionalLong;
import com.github.wrdlbrnft.streamcompat.util.Utils;

class LongStreamImpl
implements LongStream {
    private final LongIterator mIterator;

    LongStreamImpl(LongIterator iterator) {
        this.mIterator = iterator;
    }

    @Override
    public LongStream filter(LongPredicate predicate) {
        Utils.requireNonNull(predicate);
        LongPredicateIterator iterator = new LongPredicateIterator(this.mIterator, predicate);
        return new LongStreamImpl(iterator);
    }

    @Override
    public LongStream map(LongUnaryOperator mapper) {
        Utils.requireNonNull(mapper);
        LongMappingIterator iterator = new LongMappingIterator(this.mIterator, mapper);
        return new LongStreamImpl(iterator);
    }

    @Override
    public LongStream flatMap(LongFunction<? extends LongStream> mapper) {
        Utils.requireNonNull(mapper);
        LongFlatMappingIterator iterator = new LongFlatMappingIterator(this.mIterator, mapper);
        return new LongStreamImpl(iterator);
    }

    @Override
    public <U> Stream<U> mapToObj(LongFunction<? extends U> mapper) {
        Utils.requireNonNull(mapper);
        LongToObjectMappingIterator<? extends U> iterator = new LongToObjectMappingIterator<U>(this.mIterator, mapper);
        return StreamCompat.of(iterator);
    }

    @Override
    public IntStream mapToInt(LongToIntFunction mapper) {
        Utils.requireNonNull(mapper);
        LongToIntMappingIterator iterator = new LongToIntMappingIterator(this.mIterator, mapper);
        return IntStreamCompat.of(iterator);
    }

    @Override
    public DoubleStream mapToDouble(LongToDoubleFunction mapper) {
        Utils.requireNonNull(mapper);
        LongToDoubleMappingIterator iterator = new LongToDoubleMappingIterator(this.mIterator, mapper);
        return DoubleStreamCompat.of(iterator);
    }

    @Override
    public FloatStream mapToFloat(LongToFloatFunction mapper) {
        Utils.requireNonNull(mapper);
        LongToFloatMappingIterator iterator = new LongToFloatMappingIterator(this.mIterator, mapper);
        return FloatStreamCompat.of(iterator);
    }

    @Override
    public CharacterStream mapToChar(LongToCharFunction mapper) {
        Utils.requireNonNull(mapper);
        LongToCharMappingIterator iterator = new LongToCharMappingIterator(this.mIterator, mapper);
        return CharacterStreamCompat.of(iterator);
    }

    @Override
    public LongIterator iterator() {
        return this.mIterator;
    }

    @Override
    public Stream<Long> boxed() {
        return StreamCompat.of(this.mIterator);
    }

    @Override
    public LongStream limit(long limit) {
        LongLimitIterator iterator = new LongLimitIterator(this.mIterator, limit);
        return new LongStreamImpl(iterator);
    }

    @Override
    public long reduce(long identity, LongBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        long current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsInt(current, this.mIterator.nextLong());
        }
        return current;
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        if (!this.mIterator.hasNext()) {
            return OptionalLong.empty();
        }
        long current = this.mIterator.nextLong();
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsInt(current, this.mIterator.nextLong());
        }
        return OptionalLong.of(current);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator) {
        Utils.requireNonNull(supplier);
        Utils.requireNonNull(accumulator);
        R sink = supplier.get();
        while (this.mIterator.hasNext()) {
            accumulator.accept(sink, this.mIterator.nextLong());
        }
        return sink;
    }

    @Override
    public long sum() {
        return this.reduce(0L, LongStreamImpl$$Lambda$1.lambdaFactory$());
    }

    @Override
    public OptionalLong min() {
        return this.reduce(LongStreamImpl$$Lambda$2.lambdaFactory$());
    }

    @Override
    public OptionalLong max() {
        return this.reduce(LongStreamImpl$$Lambda$3.lambdaFactory$());
    }

    @Override
    public long count() {
        return this.map(LongStreamImpl$$Lambda$4.lambdaFactory$()).sum();
    }

    @Override
    public OptionalDouble average() {
        long[] avg = (long[])this.collect(LongStreamImpl$$Lambda$5.lambdaFactory$(), LongStreamImpl$$Lambda$6.lambdaFactory$());
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public OptionalLong findFirst() {
        if (this.mIterator.hasNext()) {
            return OptionalLong.of(this.mIterator.nextLong());
        }
        return OptionalLong.empty();
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        Utils.requireNonNull(predicate);
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextLong())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        Utils.requireNonNull(predicate);
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.nextLong())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        Utils.requireNonNull(predicate);
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextLong())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$average$23(long[] ll, long i) {
        ll[0] = ll[0] + 1L;
        ll[1] = ll[1] + i;
    }

    private static /* synthetic */ long[] lambda$average$22() {
        return new long[2];
    }

    private static /* synthetic */ long lambda$count$21(long i) {
        return 1L;
    }

    private static /* synthetic */ long lambda$sum$20(long a, long b) {
        return a + b;
    }

    static /* synthetic */ long access$lambda$0(long l, long l2) {
        return LongStreamImpl.lambda$sum$20(l, l2);
    }

    static /* synthetic */ long access$lambda$1(long l) {
        return LongStreamImpl.lambda$count$21(l);
    }

    static /* synthetic */ long[] access$lambda$2() {
        return LongStreamImpl.lambda$average$22();
    }

    static /* synthetic */ void access$lambda$3(long[] lArray, long l) {
        LongStreamImpl.lambda$average$23(lArray, l);
    }
}

