/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.longstream;

import com.github.wrdlbrnft.streamcompat.function.LongPredicate;
import com.github.wrdlbrnft.streamcompat.iterator.LongIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIterator;
import java.util.NoSuchElementException;

class LongPredicateIterator
extends BaseIterator<Long>
implements LongIterator {
    private final LongIterator mBaseIterator;
    private final LongPredicate mPredicate;
    private long mNext;
    private boolean mHasNext;

    LongPredicateIterator(LongIterator baseIterator, LongPredicate predicate) {
        this.mBaseIterator = baseIterator;
        this.mPredicate = predicate;
        this.moveToNext();
    }

    private void moveToNext() {
        while (this.mBaseIterator.hasNext()) {
            long item = (Long)this.mBaseIterator.next();
            if (!this.mPredicate.test(item)) continue;
            this.mNext = item;
            this.mHasNext = true;
            return;
        }
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public Long next() {
        return this.nextLong();
    }

    @Override
    public long nextLong() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        long current = this.mNext;
        this.moveToNext();
        return current;
    }
}

