/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.longstream;

import com.github.wrdlbrnft.streamcompat.function.LongFunction;
import com.github.wrdlbrnft.streamcompat.iterator.LongIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import java.util.NoSuchElementException;

class LongFlatMappingIterator
extends BaseIterator<Long>
implements LongIterator {
    private final LongIterator mBaseIterator;
    private final LongFunction<? extends LongStream> mMapper;
    private LongIterator mChild = null;
    private boolean mHasNext;
    private long mNext;

    public LongFlatMappingIterator(LongIterator iterator, LongFunction<? extends LongStream> mapper) {
        this.mBaseIterator = iterator;
        this.mMapper = mapper;
        this.moveToNext();
    }

    private void moveToNext() {
        if (this.mChild != null && this.mChild.hasNext()) {
            this.mHasNext = true;
            this.mNext = this.mChild.nextLong();
            return;
        }
        this.mChild = null;
        while (this.mBaseIterator.hasNext()) {
            long input = this.mBaseIterator.nextLong();
            LongStream stream = this.mMapper.apply(input);
            this.mChild = stream.iterator();
            if (this.mChild == null || !this.mChild.hasNext()) continue;
            this.mHasNext = true;
            this.mNext = this.mChild.nextLong();
            return;
        }
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public Long next() {
        return this.nextLong();
    }

    @Override
    public long nextLong() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        long current = this.mNext;
        this.moveToNext();
        return current;
    }
}

