/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.floatstream;

import com.github.wrdlbrnft.streamcompat.function.FloatPredicate;
import com.github.wrdlbrnft.streamcompat.iterator.FloatIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseFloatIterator;
import java.util.NoSuchElementException;

class FloatPredicateIterator
extends BaseFloatIterator
implements FloatIterator {
    private final FloatIterator mBaseIterator;
    private final FloatPredicate mPredicate;
    private float mNext;
    private boolean mHasNext;

    FloatPredicateIterator(FloatIterator baseIterator, FloatPredicate predicate) {
        this.mBaseIterator = baseIterator;
        this.mPredicate = predicate;
        this.moveToNext();
    }

    private void moveToNext() {
        while (this.mBaseIterator.hasNext()) {
            float item = ((Float)this.mBaseIterator.next()).floatValue();
            if (!this.mPredicate.test(item)) continue;
            this.mNext = item;
            this.mHasNext = true;
            return;
        }
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public float nextFloat() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        float current = this.mNext;
        this.moveToNext();
        return current;
    }
}

