/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.doublestream;

import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStream;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamCompat;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleFlatMappingIterator;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleLimitIterator;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleMappingIterator;
import com.github.wrdlbrnft.streamcompat.doublestream.DoublePredicateIterator;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamImpl$$Lambda$1;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamImpl$$Lambda$2;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamImpl$$Lambda$3;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamImpl$$Lambda$4;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamImpl$$Lambda$5;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamImpl$$Lambda$6;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamImpl$$Lambda$7;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleToCharMappingIterator;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleToFloatMappingIterator;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleToIntMappingIterator;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleToLongMappingIterator;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleToObjectMappingIterator;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamCompat;
import com.github.wrdlbrnft.streamcompat.function.DoubleBinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.DoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.DoublePredicate;
import com.github.wrdlbrnft.streamcompat.function.DoubleToCharFunction;
import com.github.wrdlbrnft.streamcompat.function.DoubleToFloatFunction;
import com.github.wrdlbrnft.streamcompat.function.DoubleToIntFunction;
import com.github.wrdlbrnft.streamcompat.function.DoubleToLongFunction;
import com.github.wrdlbrnft.streamcompat.function.DoubleUnaryOperator;
import com.github.wrdlbrnft.streamcompat.function.ObjDoubleConsumer;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat;
import com.github.wrdlbrnft.streamcompat.iterator.DoubleIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat;
import com.github.wrdlbrnft.streamcompat.util.KahanSummation;
import com.github.wrdlbrnft.streamcompat.util.OptionalDouble;
import com.github.wrdlbrnft.streamcompat.util.Utils;

class DoubleStreamImpl
implements DoubleStream {
    private final DoubleIterator mIterator;

    DoubleStreamImpl(DoubleIterator iterator) {
        this.mIterator = iterator;
    }

    @Override
    public DoubleStream filter(DoublePredicate predicate) {
        Utils.requireNonNull(predicate);
        DoublePredicateIterator iterator = new DoublePredicateIterator(this.mIterator, predicate);
        return new DoubleStreamImpl(iterator);
    }

    @Override
    public DoubleStream map(DoubleUnaryOperator mapper) {
        Utils.requireNonNull(mapper);
        DoubleMappingIterator iterator = new DoubleMappingIterator(this.mIterator, mapper);
        return new DoubleStreamImpl(iterator);
    }

    @Override
    public DoubleStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        Utils.requireNonNull(mapper);
        DoubleFlatMappingIterator iterator = new DoubleFlatMappingIterator(this.mIterator, mapper);
        return new DoubleStreamImpl(iterator);
    }

    @Override
    public <U> Stream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        Utils.requireNonNull(mapper);
        DoubleToObjectMappingIterator<? extends U> iterator = new DoubleToObjectMappingIterator<U>(this.mIterator, mapper);
        return StreamCompat.of(iterator);
    }

    @Override
    public LongStream mapToLong(DoubleToLongFunction mapper) {
        Utils.requireNonNull(mapper);
        DoubleToLongMappingIterator iterator = new DoubleToLongMappingIterator(this.mIterator, mapper);
        return LongStreamCompat.of(iterator);
    }

    @Override
    public FloatStream mapToFloat(DoubleToFloatFunction mapper) {
        Utils.requireNonNull(mapper);
        DoubleToFloatMappingIterator iterator = new DoubleToFloatMappingIterator(this.mIterator, mapper);
        return FloatStreamCompat.of(iterator);
    }

    @Override
    public IntStream mapToInt(DoubleToIntFunction mapper) {
        Utils.requireNonNull(mapper);
        DoubleToIntMappingIterator iterator = new DoubleToIntMappingIterator(this.mIterator, mapper);
        return IntStreamCompat.of(iterator);
    }

    @Override
    public CharacterStream mapToChar(DoubleToCharFunction mapper) {
        Utils.requireNonNull(mapper);
        DoubleToCharMappingIterator iterator = new DoubleToCharMappingIterator(this.mIterator, mapper);
        return CharacterStreamCompat.of(iterator);
    }

    @Override
    public DoubleIterator iterator() {
        return this.mIterator;
    }

    @Override
    public Stream<Double> boxed() {
        return StreamCompat.of(this.mIterator);
    }

    @Override
    public DoubleStream limit(long limit) {
        DoubleLimitIterator iterator = new DoubleLimitIterator(this.mIterator, limit);
        return new DoubleStreamImpl(iterator);
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        double current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsDouble(current, this.mIterator.nextDouble());
        }
        return current;
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        if (!this.mIterator.hasNext()) {
            return OptionalDouble.empty();
        }
        double current = this.mIterator.nextDouble();
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsDouble(current, this.mIterator.nextDouble());
        }
        return OptionalDouble.of(current);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator) {
        Utils.requireNonNull(supplier);
        Utils.requireNonNull(accumulator);
        R sink = supplier.get();
        while (this.mIterator.hasNext()) {
            accumulator.accept(sink, this.mIterator.nextDouble());
        }
        return sink;
    }

    @Override
    public double sum() {
        double[] summation = (double[])this.collect(DoubleStreamImpl$$Lambda$1.lambdaFactory$(), DoubleStreamImpl$$Lambda$2.lambdaFactory$());
        return KahanSummation.computeFinalSum(summation);
    }

    @Override
    public OptionalDouble min() {
        return this.reduce(DoubleStreamImpl$$Lambda$3.lambdaFactory$());
    }

    @Override
    public OptionalDouble max() {
        return this.reduce(DoubleStreamImpl$$Lambda$4.lambdaFactory$());
    }

    @Override
    public long count() {
        return this.mapToLong(DoubleStreamImpl$$Lambda$5.lambdaFactory$()).sum();
    }

    @Override
    public OptionalDouble average() {
        double[] avg = (double[])this.collect(DoubleStreamImpl$$Lambda$6.lambdaFactory$(), DoubleStreamImpl$$Lambda$7.lambdaFactory$());
        return avg[2] > 0.0 ? OptionalDouble.of(KahanSummation.computeFinalSum(avg) / avg[2]) : OptionalDouble.empty();
    }

    @Override
    public OptionalDouble findFirst() {
        return this.mIterator.hasNext() ? OptionalDouble.of(this.mIterator.nextDouble()) : OptionalDouble.empty();
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextDouble())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.nextDouble())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextDouble())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$average$10(double[] ll, double d) {
        ll[2] = ll[2] + 1.0;
        KahanSummation.sumWithCompensation(ll, d);
        ll[3] = ll[3] + d;
    }

    private static /* synthetic */ double[] lambda$average$9() {
        return new double[4];
    }

    private static /* synthetic */ long lambda$count$8(double i) {
        return 1L;
    }

    private static /* synthetic */ void lambda$sum$7(double[] ll, double d) {
        KahanSummation.sumWithCompensation(ll, d);
        ll[2] = ll[2] + d;
    }

    private static /* synthetic */ double[] lambda$sum$6() {
        return new double[3];
    }

    static /* synthetic */ double[] access$lambda$0() {
        return DoubleStreamImpl.lambda$sum$6();
    }

    static /* synthetic */ void access$lambda$1(double[] dArray, double d) {
        DoubleStreamImpl.lambda$sum$7(dArray, d);
    }

    static /* synthetic */ long access$lambda$2(double d) {
        return DoubleStreamImpl.lambda$count$8(d);
    }

    static /* synthetic */ double[] access$lambda$3() {
        return DoubleStreamImpl.lambda$average$9();
    }

    static /* synthetic */ void access$lambda$4(double[] dArray, double d) {
        DoubleStreamImpl.lambda$average$10(dArray, d);
    }
}

