/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.characterstream;

import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStream;
import com.github.wrdlbrnft.streamcompat.function.CharFunction;
import com.github.wrdlbrnft.streamcompat.iterator.CharIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseCharIterator;
import java.util.NoSuchElementException;

class CharacterFlatMappingIterator
extends BaseCharIterator
implements CharIterator {
    private final CharIterator mBaseIterator;
    private final CharFunction<? extends CharacterStream> mMapper;
    private CharIterator mChild = null;
    private boolean mHasNext;
    private char mNext;

    public CharacterFlatMappingIterator(CharIterator iterator, CharFunction<? extends CharacterStream> mapper) {
        this.mBaseIterator = iterator;
        this.mMapper = mapper;
        this.moveToNext();
    }

    private void moveToNext() {
        if (this.mChild != null && this.mChild.hasNext()) {
            this.mHasNext = true;
            this.mNext = this.mChild.nextChar();
            return;
        }
        this.mChild = null;
        while (this.mBaseIterator.hasNext()) {
            char input = this.mBaseIterator.nextChar();
            CharacterStream stream = this.mMapper.apply(input);
            this.mChild = stream.iterator();
            if (this.mChild == null || !this.mChild.hasNext()) continue;
            this.mHasNext = true;
            this.mNext = this.mChild.nextChar();
            return;
        }
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public char nextChar() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        char current = this.mNext;
        this.moveToNext();
        return current;
    }
}

