/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.util;

import com.github.wrdlbrnft.streamcompat.function.DoubleConsumer;
import com.github.wrdlbrnft.streamcompat.function.DoubleSupplier;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.NoSuchElementException;

public class OptionalDouble {
    private static final OptionalDouble EMPTY = new OptionalDouble();
    private final boolean mIsPresent;
    private final double mValue;

    private OptionalDouble() {
        this.mIsPresent = false;
        this.mValue = Double.NaN;
    }

    public static OptionalDouble empty() {
        return EMPTY;
    }

    private OptionalDouble(double value) {
        this.mIsPresent = true;
        this.mValue = value;
    }

    public static OptionalDouble of(double value) {
        return new OptionalDouble(value);
    }

    public double getAsDouble() {
        if (!this.mIsPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.mValue;
    }

    public boolean isPresent() {
        return this.mIsPresent;
    }

    public void ifPresent(DoubleConsumer consumer) {
        if (this.mIsPresent) {
            consumer.accept(this.mValue);
        }
    }

    public double orElse(double other) {
        return this.mIsPresent ? this.mValue : other;
    }

    public double orElseGet(DoubleSupplier other) {
        return this.mIsPresent ? this.mValue : other.getAsDouble();
    }

    public <X extends Throwable> double orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.mIsPresent) {
            return this.mValue;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalDouble)) {
            return false;
        }
        OptionalDouble other = (OptionalDouble)obj;
        return this.mIsPresent && other.mIsPresent ? Double.compare(this.mValue, other.mValue) == 0 : this.mIsPresent == other.mIsPresent;
    }

    public int hashCode() {
        return this.mIsPresent ? Utils.hashCode(this.mValue) : 0;
    }

    public String toString() {
        return this.mIsPresent ? String.format("OptionalDouble[%s]", this.mValue) : "OptionalDouble.empty";
    }
}

