/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.stream;

import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIterator;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import java.util.Iterator;
import java.util.NoSuchElementException;

class FlatMappingIterator<I, O>
extends BaseIterator<O>
implements Iterator<O> {
    private final Iterator<I> mBaseIterator;
    private final Function<I, ? extends Stream<? extends O>> mMapper;
    private Iterator<? extends O> mChild = null;
    private boolean mHasNext;
    private O mNext;

    public FlatMappingIterator(Iterator<I> iterator, Function<I, ? extends Stream<? extends O>> mapper) {
        this.mBaseIterator = iterator;
        this.mMapper = mapper;
        this.moveToNext();
    }

    private void moveToNext() {
        if (this.mChild != null && this.mChild.hasNext()) {
            this.mHasNext = true;
            this.mNext = this.mChild.next();
            return;
        }
        this.mChild = null;
        while (this.mBaseIterator.hasNext()) {
            I input = this.mBaseIterator.next();
            Stream<O> stream = this.mMapper.apply(input);
            this.mChild = stream.iterator();
            if (this.mChild == null || !this.mChild.hasNext()) continue;
            this.mHasNext = true;
            this.mNext = this.mChild.next();
            return;
        }
        this.mNext = null;
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public O next() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        O current = this.mNext;
        this.moveToNext();
        return current;
    }
}

