/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.stream;

import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.iterator.LongIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseLongIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

class FlatMapToLongIterator<I>
extends BaseLongIterator {
    private final Iterator<I> mBaseIterator;
    private final Function<? super I, ? extends LongStream> mMapper;
    private LongIterator mChild = null;
    private boolean mHasNext;
    private long mNext;

    public FlatMapToLongIterator(Iterator<I> iterator, Function<? super I, ? extends LongStream> mapper) {
        this.mBaseIterator = iterator;
        this.mMapper = mapper;
        this.moveToNext();
    }

    private void moveToNext() {
        if (this.mChild != null && this.mChild.hasNext()) {
            this.mHasNext = true;
            this.mNext = this.mChild.nextLong();
            return;
        }
        this.mChild = null;
        while (this.mBaseIterator.hasNext()) {
            I input = this.mBaseIterator.next();
            LongStream stream = this.mMapper.apply(input);
            this.mChild = stream.iterator();
            if (this.mChild == null || !this.mChild.hasNext()) continue;
            this.mHasNext = true;
            this.mNext = this.mChild.nextLong();
            return;
        }
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public long nextLong() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        long current = this.mNext;
        this.moveToNext();
        return current;
    }
}

