/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.stream;

import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.iterator.DoubleIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseDoubleIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

class FlatMapToDoubleIterator<I>
extends BaseDoubleIterator {
    private final Iterator<I> mBaseIterator;
    private final Function<? super I, ? extends DoubleStream> mMapper;
    private DoubleIterator mChild = null;
    private boolean mHasNext;
    private double mNext;

    public FlatMapToDoubleIterator(Iterator<I> iterator, Function<? super I, ? extends DoubleStream> mapper) {
        this.mBaseIterator = iterator;
        this.mMapper = mapper;
        this.moveToNext();
    }

    private void moveToNext() {
        if (this.mChild != null && this.mChild.hasNext()) {
            this.mHasNext = true;
            this.mNext = this.mChild.nextDouble();
            return;
        }
        this.mChild = null;
        while (this.mBaseIterator.hasNext()) {
            I input = this.mBaseIterator.next();
            DoubleStream stream = this.mMapper.apply(input);
            this.mChild = stream.iterator();
            if (this.mChild == null || !this.mChild.hasNext()) continue;
            this.mHasNext = true;
            this.mNext = this.mChild.nextDouble();
            return;
        }
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public double nextDouble() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        double current = this.mNext;
        this.moveToNext();
        return current;
    }
}

