/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.intstream;

import com.github.wrdlbrnft.streamcompat.function.IntFunction;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.iterator.IntIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIntIterator;
import java.util.NoSuchElementException;

class IntFlatMappingIterator
extends BaseIntIterator
implements IntIterator {
    private final IntIterator mBaseIterator;
    private final IntFunction<? extends IntStream> mMapper;
    private IntIterator mChild = null;
    private boolean mHasNext;
    private int mNext;

    public IntFlatMappingIterator(IntIterator iterator, IntFunction<? extends IntStream> mapper) {
        this.mBaseIterator = iterator;
        this.mMapper = mapper;
        this.moveToNext();
    }

    private void moveToNext() {
        if (this.mChild != null && this.mChild.hasNext()) {
            this.mHasNext = true;
            this.mNext = this.mChild.nextInt();
            return;
        }
        this.mChild = null;
        while (this.mBaseIterator.hasNext()) {
            int input = this.mBaseIterator.nextInt();
            IntStream stream = this.mMapper.apply(input);
            this.mChild = stream.iterator();
            if (this.mChild == null || !this.mChild.hasNext()) continue;
            this.mHasNext = true;
            this.mNext = this.mChild.nextInt();
            return;
        }
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public int nextInt() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        int current = this.mNext;
        this.moveToNext();
        return current;
    }
}

