/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.doublestream;

import com.github.wrdlbrnft.streamcompat.function.DoublePredicate;
import com.github.wrdlbrnft.streamcompat.iterator.DoubleIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseDoubleIterator;
import java.util.NoSuchElementException;

class DoublePredicateIterator
extends BaseDoubleIterator
implements DoubleIterator {
    private final DoubleIterator mBaseIterator;
    private final DoublePredicate mPredicate;
    private double mNext;
    private boolean mHasNext;

    DoublePredicateIterator(DoubleIterator baseIterator, DoublePredicate predicate) {
        this.mBaseIterator = baseIterator;
        this.mPredicate = predicate;
        this.moveToNext();
    }

    private void moveToNext() {
        while (this.mBaseIterator.hasNext()) {
            double item = (Double)this.mBaseIterator.next();
            if (!this.mPredicate.test(item)) continue;
            this.mNext = item;
            this.mHasNext = true;
            return;
        }
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public double nextDouble() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        double current = this.mNext;
        this.moveToNext();
        return current;
    }
}

