/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.charstream;

import com.github.wrdlbrnft.streamcompat.charstream.CharFlatMappingIterator;
import com.github.wrdlbrnft.streamcompat.charstream.CharLimitIterator;
import com.github.wrdlbrnft.streamcompat.charstream.CharMappingIterator;
import com.github.wrdlbrnft.streamcompat.charstream.CharPredicateIterator;
import com.github.wrdlbrnft.streamcompat.charstream.CharStream;
import com.github.wrdlbrnft.streamcompat.charstream.CharStreamImpl$$Lambda$1;
import com.github.wrdlbrnft.streamcompat.charstream.CharStreamImpl$$Lambda$2;
import com.github.wrdlbrnft.streamcompat.charstream.CharStreamImpl$$Lambda$3;
import com.github.wrdlbrnft.streamcompat.charstream.CharStreamImpl$$Lambda$4;
import com.github.wrdlbrnft.streamcompat.charstream.CharStreamImpl$$Lambda$5;
import com.github.wrdlbrnft.streamcompat.charstream.CharStreamImpl$$Lambda$6;
import com.github.wrdlbrnft.streamcompat.charstream.CharToDoubleMappingIterator;
import com.github.wrdlbrnft.streamcompat.charstream.CharToFloatMappingIterator;
import com.github.wrdlbrnft.streamcompat.charstream.CharToIntMappingIterator;
import com.github.wrdlbrnft.streamcompat.charstream.CharToLongMappingIterator;
import com.github.wrdlbrnft.streamcompat.charstream.CharToObjectMappingIterator;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamCompat;
import com.github.wrdlbrnft.streamcompat.function.CharBinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.CharFunction;
import com.github.wrdlbrnft.streamcompat.function.CharPredicate;
import com.github.wrdlbrnft.streamcompat.function.CharToDoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.CharToFloatFunction;
import com.github.wrdlbrnft.streamcompat.function.CharToIntFunction;
import com.github.wrdlbrnft.streamcompat.function.CharToLongFunction;
import com.github.wrdlbrnft.streamcompat.function.CharUnaryOperator;
import com.github.wrdlbrnft.streamcompat.function.ObjCharConsumer;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat;
import com.github.wrdlbrnft.streamcompat.iterator.CharIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat;
import com.github.wrdlbrnft.streamcompat.util.OptionalChar;
import com.github.wrdlbrnft.streamcompat.util.OptionalDouble;
import com.github.wrdlbrnft.streamcompat.util.Utils;

class CharStreamImpl
implements CharStream {
    private final CharIterator mIterator;

    CharStreamImpl(CharIterator iterator) {
        this.mIterator = iterator;
    }

    @Override
    public CharStream filter(CharPredicate predicate) {
        Utils.requireNonNull(predicate);
        CharPredicateIterator iterator = new CharPredicateIterator(this.mIterator, predicate);
        return new CharStreamImpl(iterator);
    }

    @Override
    public CharStream map(CharUnaryOperator mapper) {
        Utils.requireNonNull(mapper);
        CharMappingIterator iterator = new CharMappingIterator(this.mIterator, mapper);
        return new CharStreamImpl(iterator);
    }

    @Override
    public CharStream flatMap(CharFunction<? extends CharStream> mapper) {
        Utils.requireNonNull(mapper);
        CharFlatMappingIterator iterator = new CharFlatMappingIterator(this.mIterator, mapper);
        return new CharStreamImpl(iterator);
    }

    @Override
    public <U> Stream<U> mapToObj(CharFunction<? extends U> mapper) {
        Utils.requireNonNull(mapper);
        CharToObjectMappingIterator<? extends U> iterator = new CharToObjectMappingIterator<U>(this.mIterator, mapper);
        return StreamCompat.of(iterator);
    }

    @Override
    public LongStream mapToLong(CharToLongFunction mapper) {
        Utils.requireNonNull(mapper);
        CharToLongMappingIterator iterator = new CharToLongMappingIterator(this.mIterator, mapper);
        return LongStreamCompat.of(iterator);
    }

    @Override
    public IntStream mapToInt(CharToIntFunction mapper) {
        Utils.requireNonNull(mapper);
        CharToIntMappingIterator iterator = new CharToIntMappingIterator(this.mIterator, mapper);
        return IntStreamCompat.of(iterator);
    }

    @Override
    public DoubleStream mapToDouble(CharToDoubleFunction mapper) {
        Utils.requireNonNull(mapper);
        CharToDoubleMappingIterator iterator = new CharToDoubleMappingIterator(this.mIterator, mapper);
        return DoubleStreamCompat.of(iterator);
    }

    @Override
    public FloatStream mapToFloat(CharToFloatFunction mapper) {
        Utils.requireNonNull(mapper);
        CharToFloatMappingIterator iterator = new CharToFloatMappingIterator(this.mIterator, mapper);
        return FloatStreamCompat.of(iterator);
    }

    @Override
    public CharIterator iterator() {
        return this.mIterator;
    }

    @Override
    public Stream<Character> boxed() {
        return StreamCompat.of(this.mIterator);
    }

    @Override
    public CharStream limit(long limit) {
        CharLimitIterator iterator = new CharLimitIterator(this.mIterator, limit);
        return new CharStreamImpl(iterator);
    }

    @Override
    public char reduce(char identity, CharBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        char current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsChar(current, this.mIterator.nextChar());
        }
        return current;
    }

    @Override
    public OptionalChar reduce(CharBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        if (!this.mIterator.hasNext()) {
            return OptionalChar.empty();
        }
        char current = this.mIterator.nextChar();
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsChar(current, this.mIterator.nextChar());
        }
        return OptionalChar.of(current);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjCharConsumer<R> accumulator) {
        Utils.requireNonNull(supplier);
        Utils.requireNonNull(accumulator);
        R sink = supplier.get();
        while (this.mIterator.hasNext()) {
            accumulator.accept(sink, this.mIterator.nextChar());
        }
        return sink;
    }

    @Override
    public char sum() {
        return this.reduce('\u0000', CharStreamImpl$$Lambda$1.lambdaFactory$());
    }

    @Override
    public OptionalChar min() {
        return this.reduce(CharStreamImpl$$Lambda$2.lambdaFactory$());
    }

    @Override
    public OptionalChar max() {
        return this.reduce(CharStreamImpl$$Lambda$3.lambdaFactory$());
    }

    @Override
    public long count() {
        return this.mapToLong(CharStreamImpl$$Lambda$4.lambdaFactory$()).sum();
    }

    @Override
    public OptionalDouble average() {
        long[] avg = (long[])this.collect(CharStreamImpl$$Lambda$5.lambdaFactory$(), CharStreamImpl$$Lambda$6.lambdaFactory$());
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public OptionalChar findFirst() {
        return this.mIterator.hasNext() ? OptionalChar.of(this.mIterator.nextChar()) : OptionalChar.empty();
    }

    @Override
    public boolean anyMatch(CharPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextChar())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(CharPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.nextChar())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(CharPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextChar())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$average$5(long[] ll, char i) {
        ll[0] = ll[0] + 1L;
        ll[1] = ll[1] + (long)i;
    }

    private static /* synthetic */ long[] lambda$average$4() {
        return new long[2];
    }

    private static /* synthetic */ long lambda$count$3(char i) {
        return 1L;
    }

    private static /* synthetic */ char lambda$max$2(char a, char b) {
        return a < b ? b : a;
    }

    private static /* synthetic */ char lambda$min$1(char a, char b) {
        return a < b ? a : b;
    }

    private static /* synthetic */ char lambda$sum$0(char a, char b) {
        return (char)(a + b);
    }

    static /* synthetic */ char access$lambda$0(char c, char c2) {
        return CharStreamImpl.lambda$sum$0(c, c2);
    }

    static /* synthetic */ char access$lambda$1(char c, char c2) {
        return CharStreamImpl.lambda$min$1(c, c2);
    }

    static /* synthetic */ char access$lambda$2(char c, char c2) {
        return CharStreamImpl.lambda$max$2(c, c2);
    }

    static /* synthetic */ long access$lambda$3(char c) {
        return CharStreamImpl.lambda$count$3(c);
    }

    static /* synthetic */ long[] access$lambda$4() {
        return CharStreamImpl.lambda$average$4();
    }

    static /* synthetic */ void access$lambda$5(long[] lArray, char c) {
        CharStreamImpl.lambda$average$5(lArray, c);
    }
}

