/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.charstream;

import com.github.wrdlbrnft.streamcompat.charstream.CharStream;
import com.github.wrdlbrnft.streamcompat.function.CharFunction;
import com.github.wrdlbrnft.streamcompat.iterator.CharIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseCharIterator;
import java.util.NoSuchElementException;

class CharFlatMappingIterator
extends BaseCharIterator
implements CharIterator {
    private final CharIterator mBaseIterator;
    private final CharFunction<? extends CharStream> mMapper;
    private CharIterator mChild = null;
    private boolean mHasNext;
    private char mNext;

    public CharFlatMappingIterator(CharIterator iterator, CharFunction<? extends CharStream> mapper) {
        this.mBaseIterator = iterator;
        this.mMapper = mapper;
        this.moveToNext();
    }

    private void moveToNext() {
        if (this.mChild != null && this.mChild.hasNext()) {
            this.mHasNext = true;
            this.mNext = this.mChild.nextChar();
            return;
        }
        this.mChild = null;
        while (this.mBaseIterator.hasNext()) {
            char input = this.mBaseIterator.nextChar();
            CharStream stream = this.mMapper.apply(input);
            this.mChild = stream.iterator();
            if (this.mChild == null || !this.mChild.hasNext()) continue;
            this.mHasNext = true;
            this.mNext = this.mChild.nextChar();
            return;
        }
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public char nextChar() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        char current = this.mNext;
        this.moveToNext();
        return current;
    }
}

