/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.connection.request;

import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.github.wrdlbrnft.simplerest.connection.request.QueryParameter;
import com.github.wrdlbrnft.simplerest.connection.request.QueryParameterImpl;
import com.github.wrdlbrnft.simplerest.connection.request.RequestImpl;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface Request {
    public Method getMethod();

    public String getRelativeUrl();

    public byte[] getData();

    public boolean shouldFollowRedirects();

    public Map<String, String> getHeaders();

    public List<QueryParameter> getQueryParameters();

    public List<String> getPathSegments();

    public static class Builder {
        public static final String HEADER_NAME_COOKIES = "Cookie";
        public static final String HEADER_NAME_CONTENT_TYPE = "Content-Type";
        private final Map<String, String> mHeaderMap = new ArrayMap();
        private final List<QueryParameter> mQueryParameters = new ArrayList<QueryParameter>();
        private final List<String> mCookies = new ArrayList<String>();
        private final List<String> mPathParameters = new ArrayList<String>();
        private Method mMethod = Method.GET;
        private String mRelativeUrl = "";
        private byte[] mData = null;
        private boolean mFollowRedirects = true;

        public Builder setMethod(Method method) {
            this.mMethod = method;
            return this;
        }

        public Builder setRelativeUrl(String relativeUrl) {
            if (relativeUrl.startsWith("/")) {
                return this.setRelativeUrl(relativeUrl.substring(1));
            }
            this.mRelativeUrl = relativeUrl;
            return this;
        }

        public Builder setData(byte[] data) {
            this.mHeaderMap.put("Content-Length", data != null ? String.valueOf(data.length) : null);
            this.mData = data;
            return this;
        }

        public Builder setData(String data) {
            byte[] bytes = data.getBytes(Charset.forName("UTF-8"));
            return this.setData(bytes);
        }

        public Builder setContentType(String contentType) {
            this.mHeaderMap.put(HEADER_NAME_CONTENT_TYPE, contentType);
            return this;
        }

        public Builder setFollowRedirects(boolean followRedirects) {
            this.mFollowRedirects = followRedirects;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.mHeaderMap.put(key, value);
            return this;
        }

        public Builder addCookie(String value) {
            this.mCookies.add(value);
            return this;
        }

        public Builder addCookie(String key, String value) {
            this.mCookies.add(key + "=" + value);
            return this;
        }

        public Builder addQueryParameter(String key, String value) {
            this.mQueryParameters.add(new QueryParameterImpl(key, value));
            return this;
        }

        public Builder addPathParameter(String path) {
            if (path.startsWith("/")) {
                return this.addPathParameter(path.substring(1));
            }
            this.mPathParameters.add(path);
            return this;
        }

        public Request build() {
            if (!this.mCookies.isEmpty()) {
                this.mHeaderMap.put(HEADER_NAME_COOKIES, TextUtils.join((CharSequence)";", this.mCookies));
            }
            return new RequestImpl(this.mMethod, this.mRelativeUrl, this.mPathParameters, this.mQueryParameters, this.mFollowRedirects, this.mData, this.mHeaderMap);
        }
    }

    public static enum Method {
        POST("POST", true, true),
        GET("GET", false, true),
        PUT("PUT", true, true),
        DELETE("DELETE", false, true),
        HEAD("HEAD", false, false);

        private final String mHttpRepresentation;
        private final boolean mDoesOutput;
        private final boolean mDoesInput;

        private Method(String httpRepresentation, boolean doesOutput, boolean doesInput) {
            this.mHttpRepresentation = httpRepresentation;
            this.mDoesOutput = doesOutput;
            this.mDoesInput = doesInput;
        }

        public String getHttpRepresentation() {
            return this.mHttpRepresentation;
        }

        public boolean doesOutput() {
            return this.mDoesOutput;
        }

        public boolean doesInput() {
            return this.mDoesInput;
        }

        public String toString() {
            return this.mHttpRepresentation;
        }
    }
}

