/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.taskrunners;

import com.github.wrdlbrnft.simplerest.callbacks.ApiCallback;
import com.github.wrdlbrnft.simplerest.callbacks.ErrorCallback;
import com.github.wrdlbrnft.simplerest.tasks.ApiTask;
import com.github.wrdlbrnft.simplerest.tasks.Result;
import com.github.wrdlbrnft.simpletasks.tasks.CancelCallback;
import com.github.wrdlbrnft.simpletasks.tasks.ResultCallback;
import com.github.wrdlbrnft.simpletasks.tasks.Task;
import java.util.concurrent.CancellationException;

class ApiTaskImpl<T>
implements ApiTask<T> {
    private final Task<Result<T>> mTask;

    ApiTaskImpl(Task<Result<T>> task) {
        this.mTask = task;
    }

    @Override
    public Result<T> await() {
        return (Result)this.mTask.await();
    }

    @Override
    public Result<T> await(long timeoutMillis) {
        return (Result)this.mTask.await(timeoutMillis);
    }

    @Override
    public ApiTask<T> addCallback(final ApiCallback<T> callback) {
        this.mTask.onResult(new ResultCallback<Result<T>>(){

            public void onResult(Result<T> result) {
                callback.onResult(result.getStatusCode(), result.getData());
            }
        });
        this.mTask.onError(new com.github.wrdlbrnft.simpletasks.tasks.ErrorCallback(){

            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        });
        this.mTask.onCanceled(new CancelCallback(){

            public void onCanceled() {
                callback.onError(new CancellationException("Task was canceled."));
            }
        });
        return this;
    }

    @Override
    public ApiTask<T> onResult(final com.github.wrdlbrnft.simplerest.callbacks.ResultCallback<T> callback) {
        this.mTask.onResult(new ResultCallback<Result<T>>(){

            public void onResult(Result<T> result) {
                callback.onResult(result.getStatusCode(), result.getData());
            }
        });
        return this;
    }

    @Override
    public ApiTask<T> onError(final ErrorCallback callback) {
        this.mTask.onError(new com.github.wrdlbrnft.simpletasks.tasks.ErrorCallback(){

            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        });
        this.mTask.onCanceled(new CancelCallback(){

            public void onCanceled() {
                callback.onError(new CancellationException("Task was canceled."));
            }
        });
        return this;
    }

    @Override
    public void cancel() {
        this.mTask.cancel();
    }
}

