/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.requestmanager;

import android.support.v4.util.ArrayMap;
import com.github.wrdlbrnft.simplerest.caches.Cache;
import com.github.wrdlbrnft.simplerest.callbacks.ApiCallback;
import com.github.wrdlbrnft.simplerest.callbacks.OnModificationCallback;
import com.github.wrdlbrnft.simplerest.taskrunners.ApiTaskRunner;
import com.github.wrdlbrnft.simplerest.tasks.ApiTask;
import com.github.wrdlbrnft.simplerest.tasks.Result;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;

public class MultiCacheRequestManager<K, T> {
    private final Map<K, ApiTask<T>> mTaskMap = Collections.synchronizedMap(new ArrayMap());
    private final Cache<K, T> mCache;
    private final ApiTaskRunner mTaskRunner;
    private final OnModificationCallback<T> mModificationCallback;

    public MultiCacheRequestManager(ApiTaskRunner taskRunner, Cache<K, T> cache, OnModificationCallback<T> modificationCallback) {
        this.mTaskRunner = taskRunner;
        this.mCache = cache;
        this.mModificationCallback = modificationCallback;
    }

    public ApiTask<T> perform(final K id, Callable<Result<T>> callable) {
        T cachedItem = this.mCache.get(id);
        if (cachedItem != null) {
            return this.mTaskRunner.cacheTask(cachedItem);
        }
        ApiTask<T> runningTask = this.mTaskMap.get(id);
        if (runningTask != null) {
            return runningTask;
        }
        ApiTask<T> task = this.mTaskRunner.queueTask(callable, new ApiCallback<T>(){

            @Override
            public void onResult(int statusCode, T item) {
                MultiCacheRequestManager.this.mTaskMap.remove(id);
                if (item != null) {
                    MultiCacheRequestManager.this.mCache.put(id, item);
                    if (MultiCacheRequestManager.this.mModificationCallback != null) {
                        MultiCacheRequestManager.this.mModificationCallback.onModification(item);
                    }
                }
            }

            @Override
            public void onError() {
                MultiCacheRequestManager.this.mTaskMap.remove(id);
            }
        });
        this.mTaskMap.put(id, task);
        return task;
    }

    public void invalidateCache(K id) {
        this.mCache.evict(id);
    }

    public void clearCache() {
        this.mCache.clear();
    }
}

