/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.util;

import android.support.v4.util.ArrayMap;
import com.github.wrdlbrnft.simplerest.connection.BackendConnection;
import com.github.wrdlbrnft.simplerest.connection.request.Request;
import com.github.wrdlbrnft.simplerest.connection.response.Cookies;
import com.github.wrdlbrnft.simplerest.connection.response.Response;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BackendConnectionWrapper
implements BackendConnection {
    private static final BackendConnection DUMMY_CONNECTION = new DummyBackendConnection();
    private BackendConnection mConnection = DUMMY_CONNECTION;

    @Override
    public Response perform(Request request) {
        return this.mConnection.perform(request);
    }

    @Override
    public HttpURLConnection openConnection(Request request) {
        return this.mConnection.openConnection(request);
    }

    public void setConnection(BackendConnection connection) {
        this.mConnection = connection != null ? connection : DUMMY_CONNECTION;
    }

    private static class DummyCookies
    implements Cookies {
        private final List<String> mCookiesLib = new ArrayList<String>();

        private DummyCookies() {
        }

        @Override
        public List<String> getAll() {
            return this.mCookiesLib;
        }

        @Override
        public boolean hasKeyValuePair(String key) {
            return false;
        }

        @Override
        public String getValueForKey(String key) {
            return null;
        }
    }

    private static class DummyConnection
    extends HttpURLConnection {
        protected DummyConnection() {
            super(null);
        }

        @Override
        public void disconnect() {
        }

        @Override
        public boolean usingProxy() {
            return false;
        }

        @Override
        public void connect() throws IOException {
        }
    }

    private static class DummyResponseImpl
    implements Response {
        private final int mStatus;
        private final String mData;
        private final Cookies mCookies = new DummyCookies();
        private final Map<String, String> mHeaders = Collections.unmodifiableMap(new ArrayMap());

        public DummyResponseImpl(int status, String data) {
            this.mStatus = status;
            this.mData = data;
        }

        @Override
        public int getStatus() {
            return this.mStatus;
        }

        @Override
        public String getData() {
            return this.mData;
        }

        @Override
        public Cookies getCookies() {
            return this.mCookies;
        }

        @Override
        public Map<String, String> getHeaders() {
            return this.mHeaders;
        }

        @Override
        public String getHeaderValue(String name) {
            return null;
        }

        @Override
        public URL getLocation() {
            return null;
        }

        public String toString() {
            return "Dummy Response! Not registered yet.";
        }
    }

    private static class DummyBackendConnection
    implements BackendConnection {
        private static final DummyConnection DUMMY_HTTP_CONNECTION = new DummyConnection();

        private DummyBackendConnection() {
        }

        @Override
        public Response perform(Request request) {
            return new DummyResponseImpl(404, null);
        }

        @Override
        public HttpURLConnection openConnection(Request request) {
            return DUMMY_HTTP_CONNECTION;
        }
    }
}

