/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.certificates;

import android.content.Context;
import com.github.wrdlbrnft.simplerest.certificates.RawResourceReader;
import com.github.wrdlbrnft.simplerest.exceptions.KeystoreCreationException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class KeyStores {
    private static KeyStore newKeyStore() {
        try {
            String keyStoreType = KeyStore.getDefaultType();
            return KeyStore.getInstance(keyStoreType);
        }
        catch (KeyStoreException e) {
            throw new KeystoreCreationException("Could not create new KeyStore!", e);
        }
    }

    public static KeyStore createEmptyKeyStore() {
        try {
            KeyStore keyStore = KeyStores.newKeyStore();
            keyStore.load(null, null);
            return keyStore;
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreCreationException("Could not create empty KeyStore!", e);
        }
    }

    public static KeyStore fromRawResource(Context context, String fileName, Type type, String certificatePassword) {
        RawResourceReader reader = new RawResourceReader(context);
        InputStream stream = reader.openStream(fileName);
        return KeyStores.fromInputStream(stream, type, certificatePassword);
    }

    public static KeyStore fromInputStream(InputStream certificateStream, Type type, String certificatePassword) {
        try {
            KeyStore keyStore = KeyStore.getInstance(type.toString());
            keyStore.load(certificateStream, certificatePassword.toCharArray());
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreCreationException("Could not create KeyStore from InputStream!", e);
        }
    }

    public static enum Type {
        BKS("BKS"),
        PKCS12("PKCS12");

        private final String mName;

        private Type(String name) {
            this.mName = name;
        }

        public String toString() {
            return this.mName;
        }
    }
}

