/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.taskrunners;

import com.github.wrdlbrnft.simplerest.BaseApi;
import com.github.wrdlbrnft.simplerest.callbacks.ApiCallback;
import com.github.wrdlbrnft.simplerest.callbacks.ErrorCallback;
import com.github.wrdlbrnft.simplerest.callbacks.ResultCallback;
import com.github.wrdlbrnft.simplerest.exceptions.ApiCallFailedException;
import com.github.wrdlbrnft.simplerest.tasks.ApiTask;
import com.github.wrdlbrnft.simplerest.tasks.Result;
import com.github.wrdlbrnft.simplerest.util.StatusCode;
import com.github.wrdlbrnft.simpletasks.utils.TaskUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class StubApiTask<T>
implements ApiTask<T> {
    private volatile Result<T> mResult;
    private final List<ApiCallback<T>> mCallbacks = new ArrayList<ApiCallback<T>>();
    private AtomicBoolean mWaiting = new AtomicBoolean(false);

    @Override
    public Result<T> await() {
        try {
            this.mWaiting.set(true);
            this.mWaiting.wait();
            return this.mResult;
        }
        catch (InterruptedException e) {
            throw new ApiCallFailedException("Could not finish task", e);
        }
    }

    @Override
    public Result<T> await(long timeoutMillis) {
        try {
            this.mWaiting.set(true);
            this.mWaiting.wait(timeoutMillis);
            return this.mResult;
        }
        catch (InterruptedException e) {
            throw new ApiCallFailedException("Could not finish task", e);
        }
    }

    @Override
    public ApiTask<T> addCallback(ApiCallback<T> callback) {
        this.mCallbacks.add(callback);
        return this;
    }

    @Override
    public ApiTask<T> onResult(final ResultCallback<T> callback) {
        this.mCallbacks.add(new ApiCallback<T>(){

            @Override
            public void onResult(@StatusCode int statusCode, T result) {
                callback.onResult(statusCode, result);
            }

            @Override
            public void onError() {
            }
        });
        return this;
    }

    @Override
    public ApiTask<T> onError(final ErrorCallback callback) {
        this.mCallbacks.add(new ApiCallback<T>(){

            @Override
            public void onResult(@StatusCode int statusCode, T result) {
            }

            @Override
            public void onError() {
                callback.onError();
            }
        });
        return this;
    }

    @Override
    public void cancel() {
        this.notifyError();
    }

    public void notifyResult(final @StatusCode int statusCode, final T data) {
        this.mResult = new BaseApi.ResultImpl<T>(statusCode, data);
        if (this.mWaiting.get()) {
            this.mWaiting.notifyAll();
        }
        TaskUtils.MAIN_HANDLER.post(new Runnable(){

            @Override
            public void run() {
                for (ApiCallback callback : StubApiTask.this.mCallbacks) {
                    callback.onResult(statusCode, data);
                }
            }
        });
    }

    public void notifyError() {
        this.mResult = null;
        if (this.mWaiting.get()) {
            this.mWaiting.notifyAll();
        }
        TaskUtils.MAIN_HANDLER.post(new Runnable(){

            @Override
            public void run() {
                for (ApiCallback callback : StubApiTask.this.mCallbacks) {
                    callback.onError();
                }
            }
        });
    }
}

